/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.converter.AbstractResultSetConverter;
import org.springframework.util.StringUtils;

public class ResultSetToListOfStringConverter
extends AbstractResultSetConverter<List<String>> {
    @Override
    protected List<String> doConvertSingleValue(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(object == null ? null : object.toString());
        return list;
    }

    @Override
    protected List<String> doConvertSingleRow(Map<String, Object> row) {
        ArrayList<String> list = new ArrayList<String>(row.size());
        for (Object value : row.values()) {
            list.add(value == null ? null : value.toString());
        }
        return list;
    }

    @Override
    protected List<String> doConvertResultSet(List<Map<String, Object>> resultSet) {
        ArrayList<String> list = new ArrayList<String>(resultSet.size());
        for (Map<String, Object> row : resultSet) {
            list.add(StringUtils.arrayToCommaDelimitedString((Object[])this.doConvertSingleRow((Map)row).toArray()));
        }
        return list;
    }

    @Override
    protected Class<?> getType() {
        return List.class;
    }
}

