/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;

public class RowToListConverter
implements Converter<Row, List<Object>> {
    public List<Object> convert(Row row) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions cols = row.getColumnDefinitions();
        ArrayList<Object> list = new ArrayList<Object>(cols.size());
        for (ColumnDefinitions.Definition def : cols.asList()) {
            String name = def.getName();
            list.add(row.isNull(name) ? null : def.getType().deserialize(row.getBytesUnsafe(name), ProtocolVersion.NEWEST_SUPPORTED));
        }
        return list;
    }
}

