/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.converter.RowToMapConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class ResultSetToListConverter
implements Converter<ResultSet, List<Map<String, Object>>> {
    protected Converter<Row, Map<String, Object>> rowConverter = new RowToMapConverter();

    public ResultSetToListConverter() {
    }

    public ResultSetToListConverter(Converter<Row, Map<String, Object>> rowConverter) {
        this.setRowConverter(rowConverter);
    }

    public Converter<Row, Map<String, Object>> getRowConverter() {
        return this.rowConverter;
    }

    public void setRowConverter(Converter<Row, Map<String, Object>> rowConverter) {
        Assert.notNull(rowConverter, (String)"Converter must not be null");
        this.rowConverter = rowConverter;
    }

    public List<Map<String, Object>> convert(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Iterator i = resultSet.iterator();
        while (i.hasNext()) {
            list.add((Map<String, Object>)this.rowConverter.convert(i.next()));
        }
        return list;
    }
}

