/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.keyspace.IndexDescriptor;
import org.springframework.cassandra.core.keyspace.IndexNameSpecification;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CreateIndexSpecification
extends IndexNameSpecification<CreateIndexSpecification>
implements IndexDescriptor {
    private boolean ifNotExists = false;
    private boolean custom = false;
    private CqlIdentifier tableName;
    private CqlIdentifier columnName;
    private String using;

    public static CreateIndexSpecification createIndex() {
        return new CreateIndexSpecification();
    }

    public static CreateIndexSpecification createIndex(CqlIdentifier name) {
        return (CreateIndexSpecification)new CreateIndexSpecification().name(name);
    }

    public static CreateIndexSpecification createIndex(String name) {
        return (CreateIndexSpecification)new CreateIndexSpecification().name(name);
    }

    public CreateIndexSpecification ifNotExists() {
        return this.ifNotExists(true);
    }

    public CreateIndexSpecification ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        return this;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    public CreateIndexSpecification using(String className) {
        if (StringUtils.hasText((String)className)) {
            this.using = className;
            this.custom = true;
        } else {
            this.using = null;
            this.custom = false;
        }
        return this;
    }

    @Override
    public String getUsing() {
        return this.using;
    }

    @Override
    public CqlIdentifier getColumnName() {
        return this.columnName;
    }

    public CreateIndexSpecification tableName(String tableName) {
        return this.tableName(CqlIdentifier.cqlId(tableName));
    }

    public CreateIndexSpecification tableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"CqlIdentifier must not be null");
        this.tableName = tableName;
        return this;
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.tableName;
    }

    public CreateIndexSpecification columnName(String columnName) {
        return this.columnName(CqlIdentifier.cqlId(columnName));
    }

    public CreateIndexSpecification columnName(CqlIdentifier columnName) {
        Assert.notNull((Object)columnName, (String)"CqlIdentifier must not be null");
        this.columnName = columnName;
        return this;
    }
}

