/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.Statement;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.repository.query.DtoInstantiatingConverter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface CassandraQueryExecution {
    @Nullable
    public Object execute(Statement var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(@Nullable Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (source != null && returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new NullPointerException("processor");
            }
            if (mappingContext == null) {
                throw new NullPointerException("mappingContext");
            }
            if (instantiators == null) {
                throw new NullPointerException("instantiators");
            }
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        @Nullable
        public Object execute(Statement statement, Class<?> type) {
            Object result = this.delegate.execute(statement, type);
            return result != null ? this.converter.convert(result) : null;
        }

        public ResultProcessingExecution(@NonNull CassandraQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            if (converter == null) {
                throw new NullPointerException("converter");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class ResultSetQuery
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.getCqlOperations().queryForResultSet(statement);
        }

        public ResultSetQuery(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class SingleEntityExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.selectOne(statement, type);
        }

        public SingleEntityExecution(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class CollectionExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.select(statement, type);
        }

        public CollectionExecution(@NonNull CassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class SlicedExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            CassandraPageRequest.validatePageable(this.pageable);
            Statement statementToUse = statement.setFetchSize(this.pageable.getPageSize());
            if (this.pageable instanceof CassandraPageRequest) {
                statementToUse = statementToUse.setPagingState(((CassandraPageRequest)this.pageable).getPagingState());
            }
            return this.operations.slice(statementToUse, type);
        }

        public SlicedExecution(@NonNull CassandraOperations operations, @NonNull Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (pageable == null) {
                throw new NullPointerException("pageable");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }

    public static final class StreamExecution
    implements CassandraQueryExecution {
        @NonNull
        private final CassandraOperations operations;
        @NonNull
        private final Converter<Object, Object> resultProcessing;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.stream(statement, type).map(arg_0 -> this.resultProcessing.convert(arg_0));
        }

        public StreamExecution(@NonNull CassandraOperations operations, @NonNull Converter<Object, Object> resultProcessing) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (resultProcessing == null) {
                throw new NullPointerException("resultProcessing");
            }
            this.operations = operations;
            this.resultProcessing = resultProcessing;
        }
    }
}

