/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraUDTValueProvider
implements CassandraValueProvider {
    private final UDTValue udtValue;
    private final CodecRegistry codecRegistry;
    private final SpELExpressionEvaluator evaluator;

    public CassandraUDTValueProvider(UDTValue udtValue, CodecRegistry codecRegistry, DefaultSpELExpressionEvaluator evaluator) {
        Assert.notNull((Object)udtValue, (String)"UDTValue must not be null");
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        this.udtValue = udtValue;
        this.codecRegistry = codecRegistry;
        this.evaluator = evaluator;
    }

    @Nullable
    public <T> T getPropertyValue(CassandraPersistentProperty property) {
        String spelExpression = property.getSpelExpression();
        if (spelExpression != null) {
            return (T)this.evaluator.evaluate(spelExpression);
        }
        String name = property.getColumnName().toCql();
        DataType fieldType = this.udtValue.getType().getFieldType(name);
        return (T)this.udtValue.get(name, this.codecRegistry.codecFor(fieldType));
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        return this.udtValue.getType().contains(property.getColumnName().toCql());
    }
}

