/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DtoInstantiatingConverter
implements Converter<Object, Object> {
    private final Class<?> targetType;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context;
    private final EntityInstantiator instantiator;

    DtoInstantiatingConverter(Class<?> dtoType, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> context, EntityInstantiators instantiator) {
        Assert.notNull(dtoType, (String)"DTO type must not be null!");
        Assert.notNull(context, (String)"MappingContext must not be null!");
        Assert.notNull((Object)instantiator, (String)"EntityInstantiators must not be null!");
        this.targetType = dtoType;
        this.context = context;
        this.instantiator = instantiator.getInstantiatorFor(context.getRequiredPersistentEntity(dtoType));
    }

    public Object convert(Object source) {
        if (this.targetType.isInterface()) {
            return source;
        }
        final PersistentEntity sourceEntity = this.context.getRequiredPersistentEntity(source.getClass());
        final PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(source);
        PersistentEntity targetEntity = this.context.getRequiredPersistentEntity(this.targetType);
        Object dto = this.instantiator.createInstance(targetEntity, new ParameterValueProvider(){

            @Nullable
            public Object getParameterValue(PreferredConstructor.Parameter parameter) {
                if (parameter.getName() == null) {
                    throw new IllegalArgumentException(String.format("Parameter %s does not have a name", parameter));
                }
                return sourceAccessor.getProperty(sourceEntity.getRequiredPersistentProperty(parameter.getName()));
            }
        });
        PersistentPropertyAccessor targetAccessor = targetEntity.getPropertyAccessor(dto);
        PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        targetEntity.doWithProperties(property -> {
            if (constructor != null && !constructor.isConstructorParameter(property)) {
                return;
            }
            targetAccessor.setProperty(property, sourceAccessor.getProperty(sourceEntity.getRequiredPersistentProperty(property.getName())));
        });
        return dto;
    }
}

