/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class DefaultBridgedReactiveSession
implements ReactiveSession {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CqlSession session;

    public DefaultBridgedReactiveSession(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public DriverContext getContext() {
        return this.session.getContext();
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query2) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)query2));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query2, Object ... values) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)query2, (Object[])values));
    }

    @Override
    public Mono<ReactiveResultSet> execute(String query2, Map<String, Object> values) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)query2, values));
    }

    @Override
    public Mono<ReactiveResultSet> execute(Statement<?> statement) {
        Assert.notNull(statement, (String)"Statement must not be null");
        return Mono.fromCompletionStage(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing Statement [{}]", (Object)statement);
            }
            return this.session.executeAsync(statement);
        }).map(DefaultReactiveResultSet::new);
    }

    @Override
    public Mono<PreparedStatement> prepare(String query2) {
        Assert.hasText((String)query2, (String)"Query must not be empty");
        return this.prepare(SimpleStatement.newInstance((String)query2));
    }

    @Override
    public Mono<PreparedStatement> prepare(SimpleStatement statement) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        return Mono.fromCompletionStage(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing Statement [{}]", (Object)statement);
            }
            return this.session.prepareAsync(statement);
        });
    }

    @Override
    public void close() {
        this.session.close();
    }

    static class DefaultReactiveResultSet
    implements ReactiveResultSet {
        private final AsyncResultSet resultSet;
        private final boolean wasApplied;

        DefaultReactiveResultSet(AsyncResultSet resultSet) {
            boolean wasApplied;
            this.resultSet = resultSet;
            try {
                wasApplied = resultSet.wasApplied();
            }
            catch (Exception e) {
                wasApplied = false;
            }
            this.wasApplied = wasApplied;
        }

        @Override
        public Flux<Row> rows() {
            return this.getRows((Mono<AsyncResultSet>)Mono.just((Object)this.resultSet));
        }

        @Override
        public Flux<Row> availableRows() {
            return DefaultReactiveResultSet.toRows(this.resultSet);
        }

        private Flux<Row> getRows(Mono<AsyncResultSet> nextResults) {
            return nextResults.flatMapMany(it -> {
                Flux<Row> rows = DefaultReactiveResultSet.toRows(it);
                if (!it.hasMorePages()) {
                    return rows;
                }
                MonoProcessor processor = MonoProcessor.create();
                return rows.doOnComplete(() -> DefaultReactiveResultSet.fetchMore(it.fetchNextPage(), (MonoProcessor<AsyncResultSet>)processor)).concatWith(this.getRows((Mono<AsyncResultSet>)processor));
            });
        }

        static Flux<Row> toRows(AsyncResultSet resultSet) {
            return Flux.fromIterable((Iterable)resultSet.currentPage());
        }

        static void fetchMore(CompletionStage<AsyncResultSet> future, MonoProcessor<AsyncResultSet> sink) {
            try {
                future.whenComplete((rs, err) -> {
                    if (err != null) {
                        sink.onError(err);
                    } else {
                        sink.onNext(rs);
                        sink.onComplete();
                    }
                });
            }
            catch (Exception cause) {
                sink.onError((Throwable)cause);
            }
        }

        @Override
        public ColumnDefinitions getColumnDefinitions() {
            return this.resultSet.getColumnDefinitions();
        }

        @Override
        public boolean wasApplied() {
            return this.wasApplied;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.resultSet.getExecutionInfo();
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return Collections.singletonList(this.getExecutionInfo());
        }
    }
}

