/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveSelectOperation;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveSelectOperationSupport
implements ReactiveSelectOperation {
    private final ReactiveCassandraTemplate template;

    public ReactiveSelectOperationSupport(ReactiveCassandraTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveSelectOperation.ReactiveSelect<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveSelectSupport<T>(this.template, domainType, domainType, Query.empty(), null);
    }

    static class ReactiveSelectSupport<T>
    implements ReactiveSelectOperation.ReactiveSelect<T> {
        private final ReactiveCassandraTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        public ReactiveSelectSupport(ReactiveCassandraTemplate template, Class<?> domainType, Class<T> returnType, Query query2, CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public ReactiveSelectOperation.SelectWithProjection<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveSelectSupport<T>(this.template, this.domainType, this.returnType, this.query, tableName);
        }

        @Override
        public <R> ReactiveSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ReactiveSelectSupport<R>(this.template, this.domainType, returnType, this.query, this.tableName);
        }

        @Override
        public ReactiveSelectOperation.TerminatingSelect<T> matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ReactiveSelectSupport<T>(this.template, this.domainType, this.returnType, query2, this.tableName);
        }

        @Override
        public Mono<Long> count() {
            return this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public Mono<Boolean> exists() {
            return this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public Mono<T> first() {
            return this.template.doSelect(this.query.limit(1L), this.domainType, this.getTableName(), this.returnType).next();
        }

        @Override
        public Mono<T> one() {
            Flux<T> result = this.template.doSelect(this.query.limit(2L), this.domainType, this.getTableName(), this.returnType);
            return result.collectList().flatMap(it -> {
                if (it.isEmpty()) {
                    return Mono.empty();
                }
                if (it.size() > 1) {
                    return Mono.error((Throwable)new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result.", this.query), 1));
                }
                return Mono.just(it.get(0));
            });
        }

        @Override
        public Flux<T> all() {
            return this.template.doSelect(this.query, this.domainType, this.getTableName(), this.returnType);
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

