/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlSession;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.core.cql.session.DefaultBridgedReactiveSession;
import org.springframework.data.cassandra.observability.ObservableReactiveSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ObservableReactiveSessionFactoryBean
extends AbstractFactoryBean<ReactiveSession> {
    private final CqlSession cqlSession;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private String remoteServiceName;

    public ObservableReactiveSessionFactoryBean(CqlSession cqlSession, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)cqlSession, (String)"CqlSession must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.cqlSession = cqlSession;
        this.observationRegistry = observationRegistry;
    }

    protected ReactiveSession createInstance() {
        if (ObjectUtils.isEmpty((Object)this.getRemoteServiceName())) {
            return ObservableReactiveSessionFactory.wrap(new DefaultBridgedReactiveSession(this.cqlSession), this.observationRegistry);
        }
        return ObservableReactiveSessionFactory.wrap(new DefaultBridgedReactiveSession(this.cqlSession), this.getRemoteServiceName(), this.observationRegistry);
    }

    public Class<?> getObjectType() {
        return ReactiveSession.class;
    }

    @Nullable
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setRemoteServiceName(@Nullable String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }
}

