/*
 * Copyright 2013-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.cassandra;

import java.io.Serial;

import org.springframework.dao.TypeMismatchDataAccessException;

/**
 * Spring data access exception for a Cassandra type mismatch exception.
 *
 * @author Matthew T. Adams
 */
public class CassandraTypeMismatchException extends TypeMismatchDataAccessException {

	@Serial private static final long serialVersionUID = -7420058975444905629L;

	/**
	 * Constructor for {@link CassandraTypeMismatchException}.
	 *
	 * @param msg the detail message.
	 */
	public CassandraTypeMismatchException(String msg) {
		super(msg);
	}

	/**
	 * Constructor for {@link CassandraTypeMismatchException}.
	 *
	 * @param msg the detail message.
	 * @param cause the root cause from the underlying data access API.
	 */
	public CassandraTypeMismatchException(String msg, Throwable cause) {
		super(msg, cause);
	}
}
