/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.OngoingAssignment;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.api.querybuilder.update.UpdateWithAssignments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.convert.Where;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.cql.util.TermFactory;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.PersistentPropertyTranslator;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.cassandra.core.query.VectorSort;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.ProxyUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentLruCache;

public class StatementFactory {
    private final CassandraConverter cassandraConverter;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final EntityProjectionIntrospector introspector;
    private final ConcurrentLruCache<Class<?>, EntityProjection<?, ?>> nonProjectingCache;
    private final ConcurrentLruCache<ProjectionKey, EntityProjection<?, ?>> projectingCache;
    private KeyspaceProvider keyspaceProvider = KeyspaceProviders.ENTITY_KEYSPACE;
    private ProjectionFunction projectionFunction = ProjectionFunction.projecting();

    public StatementFactory(CassandraConverter converter) {
        this(new UpdateMapper(converter));
    }

    public StatementFactory(UpdateMapper updateMapper) {
        this(updateMapper, updateMapper);
    }

    public StatementFactory(QueryMapper queryMapper, UpdateMapper updateMapper) {
        Assert.notNull((Object)queryMapper, (String)"QueryMapper must not be null");
        Assert.notNull((Object)updateMapper, (String)"UpdateMapper must not be null");
        this.cassandraConverter = queryMapper.getConverter();
        this.queryMapper = queryMapper;
        this.updateMapper = updateMapper;
        this.introspector = EntityProjectionIntrospector.create((ProjectionFactory)this.cassandraConverter.getProjectionFactory(), (EntityProjectionIntrospector.ProjectionPredicate)EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().and((target, underlyingType) -> !this.cassandraConverter.getCustomConversions().isSimpleType(target)), (MappingContext)this.cassandraConverter.getMappingContext());
        this.nonProjectingCache = new ConcurrentLruCache(128, EntityProjection::nonProjecting);
        this.projectingCache = new ConcurrentLruCache(128, key -> this.introspector.introspect(key.returnType(), key.domainType()));
    }

    protected QueryMapper getQueryMapper() {
        return this.queryMapper;
    }

    protected UpdateMapper getUpdateMapper() {
        return this.updateMapper;
    }

    <D> EntityProjection<D, D> getEntityProjection(Class<D> domainClass) {
        return (EntityProjection)this.nonProjectingCache.get(domainClass);
    }

    <M, D> EntityProjection<M, D> getEntityProjection(Class<D> domainClass, Class<M> returnType) {
        if (returnType.equals(domainClass)) {
            return (EntityProjection)this.nonProjectingCache.get(returnType);
        }
        return (EntityProjection)this.projectingCache.get((Object)new ProjectionKey(domainClass, returnType));
    }

    public void setKeyspaceProvider(KeyspaceProvider keyspaceProvider) {
        Assert.notNull((Object)keyspaceProvider, (String)"KeyspaceProvider must not be null");
        this.keyspaceProvider = keyspaceProvider;
    }

    public ProjectionFunction getProjectionFunction() {
        return this.projectionFunction;
    }

    public void setProjectionFunction(ProjectionFunction projectionFunction) {
        Assert.notNull((Object)projectionFunction, (String)"ProjectionFunction must not be null");
        this.projectionFunction = projectionFunction;
    }

    public StatementBuilder<Select> count(Query query2, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.count(query2, entity, entity.getTableName());
    }

    public StatementBuilder<Select> count(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<Columns.Selector> selectors = Collections.singletonList(Columns.FunctionCall.from("COUNT", 1L));
        return this.createSelect(query2, entity, filter, selectors, tableName);
    }

    public StatementBuilder<Select> selectExists(Query query2, EntityProjection<?, ?> projection, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        return this.select(query2.limit(1L), projection, entity, tableName, ProjectionFunction.primaryKey());
    }

    public StatementBuilder<Select> selectExists(Object id, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        return this.selectOneById(id, entity, tableName, ProjectionFunction.primaryKey());
    }

    public StatementBuilder<Select> selectOneById(Object id, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        return this.selectOneById(id, entity, tableName, ProjectionFunction.empty());
    }

    private StatementBuilder<Select> selectOneById(Object id, CassandraPersistentEntity<?> entity, CqlIdentifier tableName, ProjectionFunction projectionFunction) {
        Where where = new Where();
        Columns columns = this.computeColumnsForProjection(this.getEntityProjection(entity.getType()), Columns.empty(), projectionFunction);
        List<Columns.Selector> selectors = this.getQueryMapper().getMappedSelectors(columns, entity);
        this.cassandraConverter.write(id, where, entity);
        StatementBuilder<Select> builder = StatementBuilder.of((Select)QueryBuilder.selectFrom((CqlIdentifier)tableName), this.cassandraConverter.getCodecRegistry());
        builder.bind((statement, factory) -> this.getSelect(selectors, entity, tableName, factory).limit(1));
        return builder.bind((statement, factory) -> (Select)statement.where(StatementFactory.toRelations(where, factory)));
    }

    public StatementBuilder<Select> select(Query query2, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.select(query2, entity, entity.getTableName());
    }

    public StatementBuilder<Select> select(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        return this.select(query2, this.getEntityProjection(entity.getType()), entity, tableName, ProjectionFunction.empty());
    }

    public StatementBuilder<Select> select(Query query2, EntityProjection<?, ?> projection, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        return this.select(query2, projection, entity, tableName, ProjectionFunction.empty());
    }

    private StatementBuilder<Select> select(Query query2, EntityProjection<?, ?> projection, CassandraPersistentEntity<?> entity, CqlIdentifier tableName, ProjectionFunction projectionFunction) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Assert.notNull((Object)projectionFunction, (String)"ProjectionFunction must not be null");
        Columns columns = this.computeColumnsForProjection(projection, query2.getColumns(), projectionFunction);
        return this.doSelect(query2.columns(columns), entity, tableName);
    }

    private StatementBuilder<Select> doSelect(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull(entity, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<Columns.Selector> selectors = this.getQueryMapper().getMappedSelectors(query2.getColumns(), entity);
        return this.createSelect(query2, entity, filter, selectors, tableName);
    }

    public StatementBuilder<RegularInsert> insert(Object objectToInsert, WriteOptions options) {
        Assert.notNull((Object)objectToInsert, (String)"Object to builder must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.cassandraConverter.getMappingContext().getRequiredPersistentEntity(objectToInsert.getClass());
        return this.insert(objectToInsert, options, entity, entity.getTableName());
    }

    public StatementBuilder<RegularInsert> insert(Object objectToInsert, WriteOptions options, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        boolean insertNulls;
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)objectToInsert, (String)"Object to insert must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (options instanceof InsertOptions) {
            InsertOptions insertOptions = (InsertOptions)options;
            insertNulls = insertOptions.isInsertNulls();
        } else {
            insertNulls = false;
        }
        LinkedHashMap object = new LinkedHashMap();
        this.cassandraConverter.write(objectToInsert, object, entity);
        StatementBuilder<RegularInsert> builder = StatementBuilder.of(QueryBuilder.insertInto((CqlIdentifier)this.getKeyspace(entity, tableName), (CqlIdentifier)tableName).valuesByIds(Collections.emptyMap()), this.cassandraConverter.getCodecRegistry()).bind((statement, factory) -> {
            Map<CqlIdentifier, Term> values = StatementFactory.createTerms(insertNulls, object, factory);
            QueryOptionsUtil.CqlStatementOptionsAccessor accessor = factory.ifBoundOrInline(bindings -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofInsert(bindings, (Insert)statement), () -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofInsert((Insert)statement));
            RegularInsert afterOptions = (RegularInsert)StatementFactory.addInsertOptions(accessor, options);
            return afterOptions.valuesByIds(values);
        });
        builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options));
        return builder;
    }

    private static Map<CqlIdentifier, Term> createTerms(boolean insertNulls, Map<CqlIdentifier, Object> object, TermFactory factory) {
        LinkedHashMap<CqlIdentifier, Term> values = new LinkedHashMap<CqlIdentifier, Term>(object.size());
        object.forEach((cqlIdentifier, o) -> {
            if (o == null && !insertNulls) {
                return;
            }
            values.put((CqlIdentifier)cqlIdentifier, factory.create(o));
        });
        return values;
    }

    public StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Query query2, Update update, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.update(query2, update, entity, entity.getTableName());
    }

    StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Query query2, Update update, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        Update mappedUpdate = this.getUpdateMapper().getMappedObject(update, entity);
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> builder = this.update(entity, tableName, mappedUpdate, filter, query2.getQueryOptions().filter(WriteOptions.class::isInstance).map(WriteOptions.class::cast));
        query2.getQueryOptions().filter(UpdateOptions.class::isInstance).map(UpdateOptions.class::cast).map(UpdateOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyUpdateIfCondition(builder, criteriaDefinitions));
        query2.getQueryOptions().ifPresent(options -> builder.transform(statementBuilder -> QueryOptionsUtil.addQueryOptions(statementBuilder, options)));
        return builder;
    }

    public StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Object objectToUpdate, WriteOptions options) {
        Assert.notNull((Object)objectToUpdate, (String)"Object to builder must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.cassandraConverter.getMappingContext().getRequiredPersistentEntity(objectToUpdate.getClass());
        return this.update(objectToUpdate, options, entity, entity.getTableName());
    }

    public StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Object objectToUpdate, WriteOptions options, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)objectToUpdate, (String)"Object to builder must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Where where = new Where();
        this.cassandraConverter.write(objectToUpdate, where, entity);
        LinkedHashMap object = new LinkedHashMap();
        this.cassandraConverter.write(objectToUpdate, object, entity);
        where.forEach((cqlIdentifier, o) -> object.remove(cqlIdentifier));
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> builder = StatementBuilder.of((com.datastax.oss.driver.api.querybuilder.update.Update)QueryBuilder.update((CqlIdentifier)this.getKeyspace(entity, tableName), (CqlIdentifier)tableName).set(new Assignment[0]).where(new Relation[0]), this.cassandraConverter.getCodecRegistry()).bind((statement, factory) -> {
            QueryOptionsUtil.CqlStatementOptionsAccessor accessor = factory.ifBoundOrInline(bindings -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofUpdate(bindings, (UpdateStart)statement), () -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofUpdate((UpdateStart)statement));
            com.datastax.oss.driver.api.querybuilder.update.Update statementToUse = StatementFactory.addUpdateOptions(accessor, options);
            return (com.datastax.oss.driver.api.querybuilder.update.Update)((UpdateWithAssignments)statementToUse).set(StatementFactory.toAssignments(object, factory)).where(StatementFactory.toRelations(where, factory));
        });
        Optional.of(options).filter(UpdateOptions.class::isInstance).map(UpdateOptions.class::cast).map(UpdateOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyUpdateIfCondition(builder, criteriaDefinitions));
        builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options));
        return builder;
    }

    public StatementBuilder<Delete> deleteById(Object id, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Where where = new Where();
        this.cassandraConverter.write(id, where, entity);
        return StatementBuilder.of((Delete)QueryBuilder.deleteFrom((CqlIdentifier)this.getKeyspace(entity, tableName), (CqlIdentifier)tableName).where(new Relation[0]), this.cassandraConverter.getCodecRegistry()).bind((statement, factory) -> (Delete)statement.where(StatementFactory.toRelations(where, factory)));
    }

    public StatementBuilder<Delete> delete(Query query2, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.delete(query2, entity, entity.getTableName());
    }

    public StatementBuilder<Delete> delete(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<CqlIdentifier> columnNames = this.getQueryMapper().getMappedColumnNames(query2.getColumns(), entity);
        StatementBuilder<Delete> builder = this.delete(columnNames, entity, tableName, filter, query2.getQueryOptions().filter(WriteOptions.class::isInstance).map(WriteOptions.class::cast));
        query2.getQueryOptions().filter(DeleteOptions.class::isInstance).map(DeleteOptions.class::cast).map(DeleteOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyDeleteIfCondition(builder, criteriaDefinitions));
        query2.getQueryOptions().ifPresent(options -> builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options)));
        return builder;
    }

    public StatementBuilder<Delete> delete(Object entity, QueryOptions options, EntityWriter<Object, Object> entityWriter, CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)entity, (String)"Object to builder must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Where where = new Where();
        entityWriter.write(entity, (Object)where);
        BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.cassandraConverter.getMappingContext().getRequiredPersistentEntity(ProxyUtils.getUserClass(entity.getClass()));
        StatementBuilder<Delete> builder = StatementBuilder.of((Delete)QueryBuilder.deleteFrom((CqlIdentifier)this.getKeyspace(persistentEntity, tableName), (CqlIdentifier)tableName).where(new Relation[0]), this.cassandraConverter.getCodecRegistry()).bind((statement, factory) -> {
            Delete statementToUse;
            if (options instanceof WriteOptions) {
                WriteOptions wo = (WriteOptions)options;
                QueryOptionsUtil.CqlStatementOptionsAccessor accessor = factory.ifBoundOrInline(bindings -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofDelete(bindings, (DeleteSelection)statement), () -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofDelete((DeleteSelection)statement));
                statementToUse = StatementFactory.addDeleteOptions(accessor, wo);
            } else {
                statementToUse = statement;
            }
            return (Delete)statementToUse.where(StatementFactory.toRelations(where, factory));
        });
        Optional.of(options).filter(DeleteOptions.class::isInstance).map(DeleteOptions.class::cast).map(DeleteOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyDeleteIfCondition(builder, criteriaDefinitions));
        builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options));
        return builder;
    }

    private Columns computeColumnsForProjection(EntityProjection<?, ?> projection, Columns columns, ProjectionFunction projectionFunction) {
        if (columns.isEmpty()) {
            return projectionFunction.otherwise(this.getProjectionFunction()).computeProjection(projection, (MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)this.cassandraConverter.getMappingContext());
        }
        return columns;
    }

    private StatementBuilder<Select> createSelect(Query query2, CassandraPersistentEntity<?> entity, Filter filter, List<Columns.Selector> selectors, CqlIdentifier tableName) {
        Sort sort = Optional.of(query2.getSort()).map(querySort -> this.getQueryMapper().getMappedSort((Sort)querySort, entity)).orElse(Sort.unsorted());
        StatementBuilder<Select> select2 = this.createSelectAndOrder(selectors, entity, tableName, filter, sort);
        if (query2.isAllowFiltering()) {
            select2.apply(Select::allowFiltering);
        }
        select2.onBuild(statementBuilder -> query2.getPagingState().ifPresent(arg_0 -> ((SimpleStatementBuilder)statementBuilder).setPagingState(arg_0)));
        if (query2.getLimit() > 0L) {
            int limit = Math.toIntExact(query2.getLimit());
            select2.bind((statement, factory) -> factory.ifBoundOrInline(bindings -> statement.limit(bindings.bind(limit)), () -> statement.limit(limit)));
        }
        query2.getQueryOptions().ifPresent(it -> select2.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, it)));
        return select2;
    }

    private @Nullable CqlIdentifier getKeyspace(CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        return this.keyspaceProvider.getKeyspace(entity, tableName);
    }

    private StatementBuilder<Select> createSelectAndOrder(List<Columns.Selector> selectors, CassandraPersistentEntity<?> entity, CqlIdentifier from, Filter filter, Sort sort) {
        StatementBuilder<Select> builder = StatementBuilder.of((Select)QueryBuilder.selectFrom((CqlIdentifier)from), this.cassandraConverter.getCodecRegistry());
        builder.bind((statement, factory) -> this.getSelect(selectors, entity, from, factory));
        builder.bind((statement, factory) -> (Select)statement.where(StatementFactory.getRelations(filter, factory)));
        if (sort.isSorted()) {
            builder.bind((statement, factory) -> {
                Select statementToUse = statement;
                if (sort instanceof VectorSort) {
                    VectorSort vs = (VectorSort)sort;
                    for (Sort.Order order : sort) {
                        Object vector = vs.getVector();
                        statementToUse = statementToUse.orderByAnnOf(order.getProperty(), (CqlVector)vector);
                    }
                } else {
                    for (Sort.Order order : sort) {
                        statementToUse = statementToUse.orderBy(order.getProperty(), order.isAscending() ? ClusteringOrder.ASC : ClusteringOrder.DESC);
                    }
                }
                return statementToUse;
            });
        }
        return builder;
    }

    private Select getSelect(List<Columns.Selector> selectors, CassandraPersistentEntity<?> entity, CqlIdentifier from, TermFactory factory) {
        if (selectors.isEmpty()) {
            return QueryBuilder.selectFrom((CqlIdentifier)this.getKeyspace(entity, from), (CqlIdentifier)from).all();
        }
        ArrayList<Selector> mappedSelectors = new ArrayList<Selector>(selectors.size());
        for (Columns.Selector selector : selectors) {
            Selector orElseGet = selector.getAlias().map(it -> StatementFactory.getSelection(selector, factory).as(it)).orElseGet(() -> StatementFactory.getSelection(selector, factory));
            mappedSelectors.add(orElseGet);
        }
        return QueryBuilder.selectFrom((CqlIdentifier)this.getKeyspace(entity, from), (CqlIdentifier)from).selectors(mappedSelectors);
    }

    private static List<Relation> getRelations(Filter filter, TermFactory factory) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Iterator<CriteriaDefinition> iterator = filter.iterator();
        while (iterator.hasNext()) {
            CriteriaDefinition criteriaDefinition = iterator.next();
            relations.add(StatementFactory.toClause(criteriaDefinition, factory));
        }
        return relations;
    }

    private static Selector getSelection(Columns.Selector selector, TermFactory factory) {
        if (selector instanceof Columns.FunctionCall) {
            Selector[] arguments = (Selector[])((Columns.FunctionCall)selector).getParameters().stream().map(param -> {
                if (param instanceof Columns.ColumnSelector) {
                    Columns.ColumnSelector s = (Columns.ColumnSelector)param;
                    return Selector.column((CqlIdentifier)s.getIdentifier());
                }
                if (param instanceof CqlIdentifier) {
                    CqlIdentifier i = (CqlIdentifier)param;
                    return Selector.column((CqlIdentifier)i);
                }
                return new SimpleSelector(param.toString());
            }).toArray(Selector[]::new);
            return Selector.function((String)selector.getExpression(), (Selector[])arguments);
        }
        return Selector.column((CqlIdentifier)CqlIdentifier.fromInternal((String)selector.getExpression()));
    }

    private StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(CassandraPersistentEntity<?> entity, CqlIdentifier table, Update mappedUpdate, Filter filter, Optional<WriteOptions> optionalOptions) {
        UpdateStart updateStart = QueryBuilder.update((CqlIdentifier)this.getKeyspace(entity, table), (CqlIdentifier)table);
        return StatementBuilder.of((com.datastax.oss.driver.api.querybuilder.update.Update)updateStart, this.cassandraConverter.getCodecRegistry()).bind((statement, factory) -> {
            com.datastax.oss.driver.api.querybuilder.update.Update statementToUse;
            WriteOptions options = optionalOptions.orElse(null);
            if (options != null) {
                QueryOptionsUtil.CqlStatementOptionsAccessor accessor = factory.ifBoundOrInline(bindings -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofUpdate(bindings, (UpdateStart)statement), () -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofUpdate((UpdateStart)statement));
                statementToUse = StatementFactory.addUpdateOptions(accessor, options);
            } else {
                statementToUse = statement;
            }
            List assignments = mappedUpdate.getUpdateOperations().stream().map(assignmentOp -> StatementFactory.getAssignment(assignmentOp, factory)).collect(Collectors.toList());
            return (com.datastax.oss.driver.api.querybuilder.update.Update)((OngoingAssignment)statementToUse).set(assignments);
        }).bind((statement, factory) -> (com.datastax.oss.driver.api.querybuilder.update.Update)statement.where(StatementFactory.getRelations(filter, factory)));
    }

    static Iterable<Relation> toRelations(Where where, TermFactory factory) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        where.forEach((cqlIdentifier, termValue) -> relations.add((Relation)Relation.column((CqlIdentifier)cqlIdentifier).isEqualTo(factory.create(termValue))));
        return relations;
    }

    static Iterable<Assignment> toAssignments(Map<CqlIdentifier, Object> object, TermFactory factory) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        object.forEach((cqlIdentifier, termValue) -> assignments.add(Assignment.setColumn((CqlIdentifier)cqlIdentifier, (Term)factory.create(termValue))));
        return assignments;
    }

    private static void applyUpdateIfCondition(StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update, Filter criteriaDefinitions) {
        update.bind((statement, factory) -> {
            List conditions = criteriaDefinitions.stream().map(it -> StatementFactory.toCondition(it, factory)).collect(Collectors.toList());
            return (com.datastax.oss.driver.api.querybuilder.update.Update)statement.if_(conditions);
        });
    }

    private static void applyDeleteIfCondition(StatementBuilder<Delete> delete, Filter criteriaDefinitions) {
        delete.bind((statement, factory) -> {
            List conditions = criteriaDefinitions.stream().map(it -> StatementFactory.toCondition(it, factory)).collect(Collectors.toList());
            return (Delete)statement.if_(conditions);
        });
    }

    private static Assignment getAssignment(Update.AssignmentOp assignmentOp, TermFactory termFactory) {
        if (assignmentOp instanceof Update.SetOp) {
            return StatementFactory.getAssignment((Update.SetOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.RemoveOp) {
            return StatementFactory.getAssignment((Update.RemoveOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.IncrOp) {
            return StatementFactory.getAssignment((Update.IncrOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.AddToOp) {
            return StatementFactory.getAssignment((Update.AddToOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.AddToMapOp) {
            return StatementFactory.getAssignment((Update.AddToMapOp)assignmentOp, termFactory);
        }
        throw new IllegalArgumentException(String.format("UpdateOp %s not supported", assignmentOp));
    }

    private static Assignment getAssignment(Update.IncrOp incrOp, TermFactory termFactory) {
        return incrOp.getValue().longValue() > 0L ? Assignment.increment((CqlIdentifier)incrOp.toCqlIdentifier(), (Term)termFactory.create(Math.abs(incrOp.getValue().longValue()))) : Assignment.decrement((CqlIdentifier)incrOp.toCqlIdentifier(), (Term)termFactory.create(Math.abs(incrOp.getValue().longValue())));
    }

    private static Assignment getAssignment(Update.SetOp updateOp, TermFactory termFactory) {
        if (updateOp instanceof Update.SetAtIndexOp) {
            return Assignment.setListValue((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(((Update.SetAtIndexOp)updateOp).getIndex()), (Term)termFactory.create(updateOp.getValue()));
        }
        if (updateOp instanceof Update.SetAtKeyOp) {
            Update.SetAtKeyOp op = (Update.SetAtKeyOp)updateOp;
            return Assignment.setMapValue((CqlIdentifier)op.toCqlIdentifier(), (Term)termFactory.create(op.getKey()), (Term)termFactory.create(op.getValue()));
        }
        return Assignment.setColumn((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
    }

    private static Assignment getAssignment(Update.RemoveOp removeOp, TermFactory termFactory) {
        if (removeOp.getValue() instanceof Set) {
            Collection collection = (Collection)removeOp.getValue();
            return new RemoveCollectionElementsAssignment(removeOp.toCqlIdentifier(), termFactory.create(collection));
        }
        if (removeOp.getValue() instanceof List) {
            Collection collection = (Collection)removeOp.getValue();
            return new RemoveCollectionElementsAssignment(removeOp.toCqlIdentifier(), termFactory.create(collection));
        }
        return Assignment.remove((CqlIdentifier)removeOp.toCqlIdentifier(), (Term)termFactory.create(removeOp.getValue()));
    }

    private static Assignment getAssignment(Update.AddToOp updateOp, TermFactory termFactory) {
        if (updateOp.getValue() instanceof Set) {
            return Assignment.append((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
        }
        return Update.AddToOp.Mode.PREPEND.equals((Object)updateOp.getMode()) ? Assignment.prepend((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue())) : Assignment.append((String)updateOp.getColumnName().toCql(), (Term)termFactory.create(updateOp.getValue()));
    }

    private static Assignment getAssignment(Update.AddToMapOp updateOp, TermFactory termFactory) {
        return Assignment.append((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
    }

    private StatementBuilder<Delete> delete(List<CqlIdentifier> columnNames, CassandraPersistentEntity<?> entity, CqlIdentifier from, Filter filter, Optional<WriteOptions> optionsOptional) {
        DeleteSelection select2 = QueryBuilder.deleteFrom((CqlIdentifier)this.getKeyspace(entity, from), (CqlIdentifier)from);
        for (CqlIdentifier columnName : columnNames) {
            select2 = select2.column(columnName);
        }
        return StatementBuilder.of((Delete)select2.where(new Relation[0]), this.cassandraConverter.getCodecRegistry()).bind((statement, factory) -> {
            Delete statementToUse;
            WriteOptions options = optionsOptional.orElse(null);
            if (options != null) {
                QueryOptionsUtil.CqlStatementOptionsAccessor accessor = factory.ifBoundOrInline(bindings -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofDelete(bindings, (DeleteSelection)statement), () -> QueryOptionsUtil.CqlStatementOptionsAccessor.ofDelete((DeleteSelection)statement));
                statementToUse = StatementFactory.addDeleteOptions(accessor, options);
            } else {
                statementToUse = statement;
            }
            return (Delete)statementToUse.where(StatementFactory.getRelations(filter, factory));
        });
    }

    static Insert addInsertOptions(QueryOptionsUtil.CqlStatementOptionsAccessor<Insert> insert, WriteOptions writeOptions) {
        InsertOptions insertOptions;
        Assert.notNull(insert, (String)"Insert must not be null");
        Insert insertToUse = QueryOptionsUtil.addWriteOptions(insert, writeOptions);
        if (writeOptions instanceof InsertOptions && (insertOptions = (InsertOptions)writeOptions).isIfNotExists()) {
            insertToUse = insertToUse.ifNotExists();
        }
        return insertToUse;
    }

    static com.datastax.oss.driver.api.querybuilder.update.Update addUpdateOptions(QueryOptionsUtil.CqlStatementOptionsAccessor<UpdateStart> update, WriteOptions writeOptions) {
        UpdateOptions updateOptions;
        Assert.notNull(update, (String)"Update must not be null");
        com.datastax.oss.driver.api.querybuilder.update.Update updateToUse = (com.datastax.oss.driver.api.querybuilder.update.Update)QueryOptionsUtil.addWriteOptions(update, writeOptions);
        if (writeOptions instanceof UpdateOptions && (updateOptions = (UpdateOptions)writeOptions).isIfExists()) {
            updateToUse = (com.datastax.oss.driver.api.querybuilder.update.Update)updateToUse.ifExists();
        }
        return updateToUse;
    }

    static Delete addDeleteOptions(QueryOptionsUtil.CqlStatementOptionsAccessor<DeleteSelection> delete, WriteOptions writeOptions) {
        DeleteOptions deleteOptions;
        Assert.notNull(delete, (String)"Delete must not be null");
        Delete deleteToUse = (Delete)QueryOptionsUtil.addWriteOptions(delete, writeOptions);
        if (writeOptions instanceof DeleteOptions && (deleteOptions = (DeleteOptions)writeOptions).isIfExists()) {
            deleteToUse = (Delete)((Delete)deleteToUse.where(new Relation[0])).ifExists();
        }
        return deleteToUse;
    }

    private static Relation toClause(CriteriaDefinition criteriaDefinition, TermFactory factory) {
        CqlIdentifier columnName = criteriaDefinition.getColumnName().getCqlIdentifier().orElseGet(() -> CqlIdentifier.fromInternal((String)criteriaDefinition.getColumnName().toCql()));
        CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
        CriteriaDefinition.Operators predicateOperator = CriteriaDefinition.Operators.from(predicate.getOperator().toString()).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown operator [%s]", predicate.getOperator())));
        ColumnRelationBuilder column = Relation.column((CqlIdentifier)columnName);
        Object value = predicate.getValue();
        switch (predicateOperator) {
            case EQ: {
                return (Relation)column.isEqualTo(factory.create(value));
            }
            case NE: {
                return (Relation)column.isNotEqualTo(factory.create(value));
            }
            case GT: {
                return (Relation)column.isGreaterThan(factory.create(value));
            }
            case GTE: {
                return (Relation)column.isGreaterThanOrEqualTo(factory.create(value));
            }
            case LT: {
                return (Relation)column.isLessThan(factory.create(value));
            }
            case LTE: {
                return (Relation)column.isLessThanOrEqualTo(factory.create(value));
            }
            case IN: {
                if (StatementFactory.isCollectionLike(value)) {
                    if (factory.canBindCollection()) {
                        Term term = factory.create(value);
                        return term instanceof BindMarker ? (Relation)column.in((BindMarker)term) : (Relation)column.in(new Term[]{term});
                    }
                    return (Relation)column.in(StatementFactory.toLiterals(value));
                }
                return (Relation)column.in(new Term[]{factory.create(value)});
            }
            case LIKE: {
                return (Relation)column.like(factory.create(value));
            }
            case IS_NOT_NULL: {
                return (Relation)column.isNotNull();
            }
            case CONTAINS: {
                Assert.state((value != null ? 1 : 0) != 0, () -> String.format("CONTAINS value for column %s is null", columnName));
                return (Relation)column.contains(factory.create(value));
            }
            case CONTAINS_KEY: {
                Assert.state((value != null ? 1 : 0) != 0, () -> String.format("CONTAINS KEY value for column %s is null", columnName));
                return (Relation)column.containsKey(factory.create(value));
            }
        }
        throw new IllegalArgumentException(String.format("Criteria %s %s %s not supported", columnName, predicate.getOperator(), value));
    }

    private static Condition toCondition(CriteriaDefinition criteriaDefinition, TermFactory factory) {
        String columnName = criteriaDefinition.getColumnName().toCql();
        CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
        CriteriaDefinition.Operators predicateOperator = CriteriaDefinition.Operators.from(predicate.getOperator().toString()).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown operator [%s]", predicate.getOperator())));
        ConditionBuilder column = Condition.column((String)columnName);
        Object value = predicate.getValue();
        switch (predicateOperator) {
            case EQ: {
                return (Condition)column.isEqualTo(factory.create(value));
            }
            case NE: {
                return (Condition)column.isNotEqualTo(factory.create(value));
            }
            case GT: {
                return (Condition)column.isGreaterThan(factory.create(value));
            }
            case GTE: {
                return (Condition)column.isGreaterThanOrEqualTo(factory.create(value));
            }
            case LT: {
                return (Condition)column.isLessThan(factory.create(value));
            }
            case LTE: {
                return (Condition)column.isLessThanOrEqualTo(factory.create(value));
            }
            case IN: {
                if (StatementFactory.isCollectionLike(value)) {
                    if (factory.canBindCollection()) {
                        Term term = factory.create(value);
                        return term instanceof BindMarker ? (Condition)column.in((BindMarker)term) : (Condition)column.in(new Term[]{term});
                    }
                    return (Condition)column.in(StatementFactory.toLiterals(value));
                }
                return (Condition)column.in(new Term[]{factory.create(value)});
            }
        }
        throw new IllegalArgumentException(String.format("Criteria %s %s %s not supported for IF Conditions", columnName, predicate.getOperator(), value));
    }

    static List<Term> toLiterals(@Nullable Object arrayOrList) {
        return StatementFactory.toLiterals(arrayOrList, QueryBuilder::literal);
    }

    static List<Term> toLiterals(@Nullable Object arrayOrList, Function<Object, Term> termFactory) {
        if (arrayOrList instanceof List) {
            List list = (List)arrayOrList;
            ArrayList<Term> literals = new ArrayList<Term>(list.size());
            for (Object o : list) {
                literals.add(termFactory.apply(o));
            }
            return literals;
        }
        if (arrayOrList != null && arrayOrList.getClass().isArray()) {
            Object[] array = (Object[])arrayOrList;
            ArrayList<Term> literals = new ArrayList<Term>(array.length);
            for (Object o : array) {
                literals.add(termFactory.apply(o));
            }
            return literals;
        }
        return Collections.emptyList();
    }

    private static boolean isCollectionLike(@Nullable Object value) {
        return value instanceof List || value != null && value.getClass().isArray();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum KeyspaceProviders implements KeyspaceProvider
    {
        ENTITY_KEYSPACE{

            @Override
            public @Nullable CqlIdentifier getKeyspace(CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
                return entity.getKeyspace();
            }
        }
        ,
        SESSION_KEYSPACE{

            @Override
            public @Nullable CqlIdentifier getKeyspace(CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
                return null;
            }
        };

    }

    @FunctionalInterface
    public static interface KeyspaceProvider {
        public static KeyspaceProvider session() {
            return KeyspaceProviders.SESSION_KEYSPACE;
        }

        public static KeyspaceProvider entity() {
            return KeyspaceProviders.SESSION_KEYSPACE;
        }

        public @Nullable CqlIdentifier getKeyspace(CassandraPersistentEntity<?> var1, CqlIdentifier var2);
    }

    public static interface ProjectionFunction {
        public Columns computeProjection(EntityProjection<?, ?> var1, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> var2);

        default public ProjectionFunction otherwise(ProjectionFunction fallback) {
            return (projection, mappingContext) -> {
                Columns columns = this.computeProjection(projection, mappingContext);
                return columns.isEmpty() ? fallback.computeProjection(projection, mappingContext) : columns;
            };
        }

        public static ProjectionFunction empty() {
            return ProjectionFunctions.EMPTY;
        }

        public static ProjectionFunction primaryKey() {
            return ProjectionFunctions.PRIMARY_KEY;
        }

        public static ProjectionFunction mappedProperties() {
            return ProjectionFunctions.MAPPED_PROPERTIES;
        }

        public static ProjectionFunction projecting() {
            return ProjectionFunctions.PROJECTION;
        }
    }

    record ProjectionKey(Class<?> domainType, Class<?> returnType) {
    }

    private static class RemoveCollectionElementsAssignment
    implements Assignment {
        private final CqlIdentifier columnId;
        private final Term value;

        protected RemoveCollectionElementsAssignment(CqlIdentifier columnId, Term value) {
            this.columnId = columnId;
            this.value = value;
        }

        public void appendTo(StringBuilder builder) {
            builder.append(String.format("%1$s=%1$s-%2$s", this.columnId.asCql(true), this.buildRightOperand()));
        }

        private String buildRightOperand() {
            StringBuilder builder = new StringBuilder();
            this.value.appendTo(builder);
            return builder.toString();
        }

        public boolean isIdempotent() {
            return this.value.isIdempotent();
        }

        public Term getValue() {
            return this.value;
        }
    }

    static class SimpleSelector
    implements Selector {
        private final String selector;

        SimpleSelector(String selector) {
            this.selector = selector;
        }

        public Selector as(CqlIdentifier alias) {
            throw new UnsupportedOperationException();
        }

        public @Nullable CqlIdentifier getAlias() {
            return null;
        }

        public void appendTo(StringBuilder builder) {
            builder.append(this.selector);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ProjectionFunctions implements ProjectionFunction
    {
        EMPTY{

            @Override
            public Columns computeProjection(EntityProjection<?, ?> projection, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> context) {
                return Columns.empty();
            }

            @Override
            public ProjectionFunction otherwise(ProjectionFunction fallback) {
                return fallback;
            }
        }
        ,
        MAPPED_PROPERTIES{

            @Override
            public Columns computeProjection(EntityProjection<?, ?> projection, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> context) {
                CassandraPersistentEntity entity = (CassandraPersistentEntity)context.getRequiredPersistentEntity(projection.getActualDomainType());
                ArrayList<String> properties = new ArrayList<String>();
                Iterator iterator = entity.iterator();
                while (iterator.hasNext()) {
                    CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
                    properties.add(property.getName());
                }
                return Columns.from(properties.toArray(new String[0]));
            }
        }
        ,
        PRIMARY_KEY{

            @Override
            public Columns computeProjection(EntityProjection<?, ?> projection, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> context) {
                CassandraPersistentEntity entity = (CassandraPersistentEntity)context.getRequiredPersistentEntity(projection.getActualDomainType());
                ArrayList<String> primaryKeyColumns = new ArrayList<String>();
                Iterator iterator = entity.iterator();
                while (iterator.hasNext()) {
                    CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
                    if (!property.isIdProperty()) continue;
                    primaryKeyColumns.add(property.getName());
                }
                return Columns.from(primaryKeyColumns.toArray(new String[0]));
            }
        }
        ,
        PROJECTION{

            @Override
            public Columns computeProjection(EntityProjection<?, ?> projection, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> context) {
                if (!projection.isProjection()) {
                    return Columns.empty();
                }
                if (ClassUtils.isAssignable((Class)projection.getDomainType().getType(), (Class)projection.getMappedType().getType()) || ClassUtils.isAssignable(Map.class, (Class)projection.getMappedType().getType()) || ClassUtils.isAssignable(ResultSet.class, (Class)projection.getMappedType().getType())) {
                    return Columns.empty();
                }
                Columns columns = Columns.empty();
                if (projection.isClosedProjection()) {
                    for (EntityProjection.PropertyProjection propertyProjection : projection) {
                        columns = columns.include(propertyProjection.getPropertyPath().toDotPath());
                    }
                } else {
                    CassandraPersistentEntity mapped = (CassandraPersistentEntity)context.getRequiredPersistentEntity(projection.getMappedType());
                    PersistentPropertyTranslator translator = PersistentPropertyTranslator.create((CassandraPersistentEntity)context.getRequiredPersistentEntity(projection.getActualDomainType()), Predicates.negate(CassandraPersistentProperty::hasExplicitColumnName));
                    Iterator iterator = mapped.iterator();
                    while (iterator.hasNext()) {
                        CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
                        columns = columns.include(translator.translate(property).getColumnName());
                    }
                }
                return columns;
            }
        };

    }
}

