/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Collection;
import org.springframework.data.domain.ExampleMatcher;

public class ExampleMatcherAccessor {
    private final ExampleMatcher specification;

    public ExampleMatcherAccessor(ExampleMatcher specification) {
        this.specification = specification;
    }

    public Collection<ExampleMatcher.PropertySpecifier> getPropertySpecifiers() {
        return this.specification.getPropertySpecifiers().getSpecifiers();
    }

    public boolean hasPropertySpecifier(String path) {
        return this.specification.getPropertySpecifiers().hasSpecifierForPath(path);
    }

    public ExampleMatcher.PropertySpecifier getPropertySpecifier(String path) {
        return this.specification.getPropertySpecifiers().getForPath(path);
    }

    public boolean hasPropertySpecifiers() {
        return this.specification.getPropertySpecifiers().hasValues();
    }

    public ExampleMatcher.StringMatcher getStringMatcherForPath(String path) {
        if (!this.hasPropertySpecifier(path)) {
            return this.specification.getDefaultStringMatcher();
        }
        ExampleMatcher.PropertySpecifier specifier = this.getPropertySpecifier(path);
        return specifier.getStringMatcher() != null ? specifier.getStringMatcher() : this.specification.getDefaultStringMatcher();
    }

    public ExampleMatcher.NullHandler getNullHandler() {
        return this.specification.getNullHandler();
    }

    public ExampleMatcher.StringMatcher getDefaultStringMatcher() {
        return this.specification.getDefaultStringMatcher();
    }

    public boolean isIgnoreCaseEnabled() {
        return this.specification.isIgnoreCaseEnabled();
    }

    public boolean isIgnoredPath(String path) {
        return this.specification.isIgnoredPath(path);
    }

    public boolean isIgnoreCaseForPath(String path) {
        if (!this.hasPropertySpecifier(path)) {
            return this.specification.isIgnoreCaseEnabled();
        }
        ExampleMatcher.PropertySpecifier specifier = this.getPropertySpecifier(path);
        return specifier.getIgnoreCase() != null ? specifier.getIgnoreCase().booleanValue() : this.specification.isIgnoreCaseEnabled();
    }

    public ExampleMatcher.PropertyValueTransformer getValueTransformerForPath(String path) {
        if (!this.hasPropertySpecifier(path)) {
            return ExampleMatcher.NoOpPropertyValueTransformer.INSTANCE;
        }
        return this.getPropertySpecifier(path).getPropertyValueTransformer();
    }
}

