/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.lang.reflect.Field;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.data.auditing.AnnotationAuditingMetadata;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.domain.Auditable;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;

class AuditableBeanWrapperFactory {
    AuditableBeanWrapperFactory() {
    }

    public AuditableBeanWrapper getBeanWrapperFor(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Auditable) {
            return new AuditableInterfaceBeanWrapper((Auditable)source);
        }
        AnnotationAuditingMetadata metadata = AnnotationAuditingMetadata.getMetadata(source.getClass());
        if (metadata.isAuditable()) {
            return new ReflectionAuditingBeanWrapper(source);
        }
        return null;
    }

    static class ReflectionAuditingBeanWrapper
    implements AuditableBeanWrapper {
        private final AnnotationAuditingMetadata metadata;
        private final Object target;

        public ReflectionAuditingBeanWrapper(Object target) {
            Assert.notNull((Object)target, (String)"Target object must not be null!");
            this.metadata = AnnotationAuditingMetadata.getMetadata(target.getClass());
            this.target = target;
        }

        public void setCreatedBy(Object value) {
            this.setField(this.metadata.getCreatedByField(), value);
        }

        public void setCreatedDate(DateTime value) {
            this.setDateField(this.metadata.getCreatedDateField(), value);
        }

        public void setLastModifiedBy(Object value) {
            this.setField(this.metadata.getLastModifiedByField(), value);
        }

        public void setLastModifiedDate(DateTime value) {
            this.setDateField(this.metadata.getLastModifiedDateField(), value);
        }

        private void setField(Field field, Object value) {
            if (field != null) {
                ReflectionUtils.setField(field, this.target, value);
            }
        }

        private void setDateField(Field field, DateTime value) {
            if (field == null) {
                return;
            }
            ReflectionUtils.setField(field, this.target, this.getDateValueToSet(value, field));
        }

        private Object getDateValueToSet(DateTime value, Field field) {
            if (value == null) {
                return null;
            }
            Class<?> targetType = field.getType();
            if (DateTime.class.equals(targetType)) {
                return value;
            }
            if (Date.class.equals(targetType)) {
                return value.toDate();
            }
            if (Long.class.equals(targetType) || Long.TYPE.equals(targetType)) {
                return value.getMillis();
            }
            throw new IllegalArgumentException(String.format("Invalid date type for field %s! Supported types are %s.", field, AnnotationAuditingMetadata.SUPPORTED_DATE_TYPES));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AuditableInterfaceBeanWrapper
    implements AuditableBeanWrapper {
        private final Auditable<Object, ?> auditable;

        public AuditableInterfaceBeanWrapper(Auditable<Object, ?> auditable) {
            this.auditable = auditable;
        }

        @Override
        public void setCreatedBy(Object value) {
            this.auditable.setCreatedBy(value);
        }

        @Override
        public void setCreatedDate(DateTime value) {
            this.auditable.setCreatedDate(value);
        }

        @Override
        public void setLastModifiedBy(Object value) {
            this.auditable.setLastModifiedBy(value);
        }

        @Override
        public void setLastModifiedDate(DateTime value) {
            this.auditable.setLastModifiedDate(value);
        }
    }
}

