/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReflectionEntityInstantiator implements EntityInstantiator
{
    INSTANCE;


    @Override
    public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
        PreferredConstructor<T, P> constructor = entity.getPersistenceConstructor();
        if (constructor == null) {
            try {
                Class<T> clazz = entity.getType();
                if (clazz.isArray()) {
                    Class<Object> ctype = clazz;
                    int dims = 0;
                    while (ctype.isArray()) {
                        ctype = ctype.getComponentType();
                        ++dims;
                    }
                    return (T)Array.newInstance(clazz, dims);
                }
                return (T)BeanUtils.instantiateClass(entity.getType());
            }
            catch (BeanInstantiationException e) {
                throw new MappingInstantiationException(entity, Collections.<Object>emptyList(), (Exception)((Object)e));
            }
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (null != provider && constructor.hasParameters()) {
            for (PreferredConstructor.Parameter<Object, P> parameter : constructor.getParameters()) {
                params.add(provider.getParameterValue(parameter));
            }
        }
        try {
            return (T)BeanUtils.instantiateClass(constructor.getConstructor(), (Object[])params.toArray());
        }
        catch (BeanInstantiationException e) {
            throw new MappingInstantiationException(entity, params, (Exception)((Object)e));
        }
    }
}

