/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BeanWrapper<T> {
    private final T bean;
    private final ConversionService conversionService;

    public static <T> BeanWrapper<T> create(T bean, ConversionService conversionService) {
        Assert.notNull(bean, (String)"Wrapped instance must not be null!");
        return new BeanWrapper<T>(bean, conversionService);
    }

    private BeanWrapper(T bean, ConversionService conversionService) {
        this.bean = bean;
        this.conversionService = conversionService;
    }

    public void setProperty(PersistentProperty<?> property, Object value) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        Method setter = property.getSetter();
        try {
            if (!property.usePropertyAccess()) {
                Object valueToSet = this.getPotentiallyConvertedValue(value, property.getType());
                ReflectionUtils.makeAccessible((Field)property.getField());
                ReflectionUtils.setField((Field)property.getField(), this.bean, valueToSet);
            } else if (property.usePropertyAccess() && setter != null) {
                Class<?>[] paramTypes = setter.getParameterTypes();
                Object valueToSet = this.getPotentiallyConvertedValue(value, paramTypes[0]);
                ReflectionUtils.makeAccessible((Method)setter);
                ReflectionUtils.invokeMethod((Method)setter, this.bean, (Object[])new Object[]{valueToSet});
            }
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    public Object getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType());
    }

    public <S> S getProperty(PersistentProperty<?> property, Class<? extends S> type) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        try {
            Object obj = null;
            if (!property.usePropertyAccess()) {
                Field field = property.getField();
                ReflectionUtils.makeAccessible((Field)field);
                obj = ReflectionUtils.getField((Field)field, this.bean);
            }
            Method getter = property.getGetter();
            if (property.usePropertyAccess() && getter != null) {
                ReflectionUtils.makeAccessible((Method)getter);
                obj = ReflectionUtils.invokeMethod((Method)getter, this.bean);
            }
            return this.getPotentiallyConvertedValue(obj, type);
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    private <S> S getPotentiallyConvertedValue(Object source, Class<S> targetType) {
        boolean conversionNeeded;
        boolean conversionServiceAvailable = this.conversionService != null;
        boolean bl = conversionNeeded = source == null || !targetType.isAssignableFrom(source.getClass());
        if (conversionServiceAvailable && conversionNeeded) {
            return (S)this.conversionService.convert(source, targetType);
        }
        return (S)source;
    }

    public T getBean() {
        return this.bean;
    }
}

