/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ClassGeneratingPropertyAccessorFactory
implements PersistentPropertyAccessorFactory {
    private final ThreadLocal<Object[]> argumentCache = ThreadLocal.withInitial(() -> new Object[1]);
    private volatile Map<PersistentEntity<?, ?>, Constructor<?>> constructorMap = new HashMap(32);
    private volatile Map<TypeInformation<?>, Class<PersistentPropertyAccessor>> propertyAccessorClasses = new HashMap(32);

    @Override
    public PersistentPropertyAccessor getPropertyAccessor(PersistentEntity<?, ?> entity, Object bean) {
        Object constructorMap;
        Constructor<?> constructor = this.constructorMap.get(entity);
        if (constructor == null) {
            Class<PersistentPropertyAccessor> accessorClass = this.potentiallyCreateAndRegisterPersistentPropertyAccessorClass(entity);
            constructor = accessorClass.getConstructors()[0];
            constructorMap = new HashMap(this.constructorMap);
            constructorMap.put(entity, constructor);
            this.constructorMap = constructorMap;
        }
        Object[] args = this.argumentCache.get();
        args[0] = bean;
        try {
            constructorMap = (PersistentPropertyAccessor)constructor.newInstance(args);
            return constructorMap;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create persistent property accessor for %s", entity), e);
        }
        finally {
            args[0] = null;
        }
    }

    @Override
    public boolean isSupported(PersistentEntity<?, ?> entity) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        return ClassGeneratingPropertyAccessorFactory.isClassLoaderDefineClassAvailable(entity) && ClassGeneratingPropertyAccessorFactory.isTypeInjectable(entity) && this.hasUniquePropertyHashCodes(entity);
    }

    private static boolean isClassLoaderDefineClassAvailable(PersistentEntity<?, ?> entity) {
        try {
            return ReflectionUtils.findMethod(entity.getType().getClassLoader().getClass(), (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class}) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isTypeInjectable(PersistentEntity<?, ?> entity) {
        return entity.getType().getClassLoader() != null && !entity.getType().getPackage().getName().startsWith("java");
    }

    private boolean hasUniquePropertyHashCodes(PersistentEntity<?, ?> entity) {
        HashSet hashCodes = new HashSet();
        AtomicInteger propertyCount = new AtomicInteger();
        entity.doWithProperties(property -> {
            hashCodes.add(property.getName().hashCode());
            propertyCount.incrementAndGet();
        });
        entity.doWithAssociations(association -> {
            if (association.getInverse() != null) {
                hashCodes.add(association.getInverse().getName().hashCode());
                propertyCount.incrementAndGet();
            }
        });
        return hashCodes.size() == propertyCount.get();
    }

    private synchronized Class<PersistentPropertyAccessor> potentiallyCreateAndRegisterPersistentPropertyAccessorClass(PersistentEntity<?, ?> entity) {
        Map<TypeInformation<?>, Class<PersistentPropertyAccessor>> map = this.propertyAccessorClasses;
        Class<PersistentPropertyAccessor> propertyAccessorClass = map.get(entity.getTypeInformation());
        if (propertyAccessorClass != null) {
            return propertyAccessorClass;
        }
        propertyAccessorClass = this.createAccessorClass(entity);
        map = new HashMap(map);
        map.put(entity.getTypeInformation(), propertyAccessorClass);
        this.propertyAccessorClasses = map;
        return propertyAccessorClass;
    }

    private Class<PersistentPropertyAccessor> createAccessorClass(PersistentEntity<?, ?> entity) {
        try {
            return PropertyAccessorClassGenerator.generateCustomAccessorClass(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String referenceName(Class<?> type) {
        if (type.isArray()) {
            return Type.getInternalName(type);
        }
        return ClassGeneratingPropertyAccessorFactory.referenceName(Type.getInternalName(type));
    }

    private static String referenceName(String internalTypeName) {
        return String.format("L%s;", internalTypeName);
    }

    private static Map<String, PropertyStackAddress> createPropertyStackMap(List<PersistentProperty<?>> persistentProperties) {
        HashMap<String, PropertyStackAddress> stackmap = new HashMap<String, PropertyStackAddress>();
        for (PersistentProperty<?> property : persistentProperties) {
            stackmap.put(property.getName(), new PropertyStackAddress(new Label(), property.getName().hashCode()));
        }
        return stackmap;
    }

    private static Class<?> autoboxType(Class<?> unboxed) {
        if (unboxed.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (unboxed.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (unboxed.equals(Character.TYPE)) {
            return Character.class;
        }
        if (unboxed.equals(Double.TYPE)) {
            return Double.class;
        }
        if (unboxed.equals(Float.TYPE)) {
            return Float.class;
        }
        if (unboxed.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (unboxed.equals(Long.TYPE)) {
            return Long.class;
        }
        if (unboxed.equals(Short.TYPE)) {
            return Short.class;
        }
        if (unboxed.equals(Void.TYPE)) {
            return Void.class;
        }
        return unboxed;
    }

    private static void autoboxIfNeeded(Class<?> in, Class<?> out, MethodVisitor visitor) {
        if (in.equals(Boolean.class) && out.equals(Boolean.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        }
        if (in.equals(Boolean.TYPE) && out.equals(Boolean.class)) {
            visitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        }
        if (in.equals(Byte.class) && out.equals(Byte.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
        }
        if (in.equals(Byte.TYPE) && out.equals(Byte.class)) {
            visitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        }
        if (in.equals(Character.class) && out.equals(Character.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
        }
        if (in.equals(Character.TYPE) && out.equals(Character.class)) {
            visitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        }
        if (in.equals(Double.class) && out.equals(Double.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
        }
        if (in.equals(Double.TYPE) && out.equals(Double.class)) {
            visitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        }
        if (in.equals(Float.class) && out.equals(Float.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
        }
        if (in.equals(Float.TYPE) && out.equals(Float.class)) {
            visitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        }
        if (in.equals(Integer.class) && out.equals(Integer.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        }
        if (in.equals(Integer.TYPE) && out.equals(Integer.class)) {
            visitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        }
        if (in.equals(Long.class) && out.equals(Long.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
        }
        if (in.equals(Long.TYPE) && out.equals(Long.class)) {
            visitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        }
        if (in.equals(Short.class) && out.equals(Short.TYPE)) {
            visitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
        }
        if (in.equals(Short.TYPE) && out.equals(Short.class)) {
            visitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        }
    }

    private static String signatureTypeName(Class<?> type) {
        if (type.equals(Boolean.TYPE)) {
            return "Z";
        }
        if (type.equals(Byte.TYPE)) {
            return "B";
        }
        if (type.equals(Character.TYPE)) {
            return "C";
        }
        if (type.equals(Double.TYPE)) {
            return "D";
        }
        if (type.equals(Float.TYPE)) {
            return "F";
        }
        if (type.equals(Integer.TYPE)) {
            return "I";
        }
        if (type.equals(Long.TYPE)) {
            return "J";
        }
        if (type.equals(Short.TYPE)) {
            return "S";
        }
        if (type.equals(Void.TYPE)) {
            return "V";
        }
        return ClassGeneratingPropertyAccessorFactory.referenceName(type);
    }

    static class PropertyStackAddress
    implements Comparable<PropertyStackAddress> {
        @NonNull
        private final Label label;
        private final int hash;

        @Override
        public int compareTo(PropertyStackAddress o) {
            return this.hash < o.hash ? -1 : (this.hash == o.hash ? 0 : 1);
        }

        @ConstructorProperties(value={"label", "hash"})
        public PropertyStackAddress(@NonNull Label label, int hash) {
            if (label == null) {
                throw new IllegalArgumentException("label is null");
            }
            this.label = label;
            this.hash = hash;
        }
    }

    static class PropertyAccessorClassGenerator {
        private static final String INIT = "<init>";
        private static final String CLINIT = "<clinit>";
        private static final String TAG = "_Accessor_";
        private static final String JAVA_LANG_OBJECT = "java/lang/Object";
        private static final String JAVA_LANG_STRING = "java/lang/String";
        private static final String JAVA_LANG_REFLECT_METHOD = "java/lang/reflect/Method";
        private static final String JAVA_LANG_INVOKE_METHOD_HANDLE = "java/lang/invoke/MethodHandle";
        private static final String JAVA_LANG_CLASS = "java/lang/Class";
        private static final String BEAN_FIELD = "bean";
        private static final String THIS_REF = "this";
        private static final String PERSISTENT_PROPERTY = "org/springframework/data/mapping/PersistentProperty";
        private static final String SET_ACCESSIBLE = "setAccessible";
        private static final String JAVA_LANG_REFLECT_FIELD = "java/lang/reflect/Field";
        private static final String JAVA_LANG_INVOKE_METHOD_HANDLES = "java/lang/invoke/MethodHandles";
        private static final String JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP = "java/lang/invoke/MethodHandles$Lookup";
        private static final String JAVA_LANG_UNSUPPORTED_OPERATION_EXCEPTION = "java/lang/UnsupportedOperationException";
        private static final String[] IMPLEMENTED_INTERFACES = new String[]{Type.getInternalName(PersistentPropertyAccessor.class)};

        PropertyAccessorClassGenerator() {
        }

        static Class<?> generateCustomAccessorClass(PersistentEntity<?, ?> entity) {
            String className = PropertyAccessorClassGenerator.generateClassName(entity);
            byte[] bytecode = PropertyAccessorClassGenerator.generateBytecode(className.replace('.', '/'), entity);
            Class<?> type = entity.getType();
            try {
                return ReflectUtils.defineClass((String)className, (byte[])bytecode, (ClassLoader)type.getClassLoader(), (ProtectionDomain)type.getProtectionDomain());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        static byte[] generateBytecode(String internalClassName, PersistentEntity<?, ?> entity) {
            ClassWriter cw = new ClassWriter(1);
            cw.visit(50, 33, internalClassName, null, JAVA_LANG_OBJECT, IMPLEMENTED_INTERFACES);
            List<PersistentProperty<?>> persistentProperties = PropertyAccessorClassGenerator.getPersistentProperties(entity);
            PropertyAccessorClassGenerator.visitFields(entity, persistentProperties, cw);
            PropertyAccessorClassGenerator.visitDefaultConstructor(entity, internalClassName, cw);
            PropertyAccessorClassGenerator.visitStaticInitializer(entity, persistentProperties, internalClassName, cw);
            PropertyAccessorClassGenerator.visitBeanGetter(entity, internalClassName, cw);
            PropertyAccessorClassGenerator.visitSetProperty(entity, persistentProperties, internalClassName, cw);
            PropertyAccessorClassGenerator.visitGetProperty(entity, persistentProperties, internalClassName, cw);
            cw.visitEnd();
            return cw.toByteArray();
        }

        private static List<PersistentProperty<?>> getPersistentProperties(PersistentEntity<?, ?> entity) {
            ArrayList persistentProperties = new ArrayList();
            entity.doWithAssociations(association -> {
                if (association.getInverse() != null) {
                    persistentProperties.add((PersistentProperty<?>)association.getInverse());
                }
            });
            entity.doWithProperties(property -> persistentProperties.add(property));
            return persistentProperties;
        }

        private static void visitFields(PersistentEntity<?, ?> entity, List<PersistentProperty<?>> persistentProperties, ClassWriter cw) {
            cw.visitInnerClass(JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP, JAVA_LANG_INVOKE_METHOD_HANDLES, "Lookup", 26);
            boolean accessibleType = PropertyAccessorClassGenerator.isAccessible(entity);
            if (accessibleType) {
                cw.visitField(18, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(Type.getInternalName(entity.getType())), null, null).visitEnd();
            } else {
                cw.visitField(18, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), null, null).visitEnd();
            }
            for (PersistentProperty<?> property : persistentProperties) {
                if (PropertyAccessorClassGenerator.generateMethodHandle(entity, property.getSetter())) {
                    cw.visitField(26, PropertyAccessorClassGenerator.setterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE), null, null).visitEnd();
                }
                if (PropertyAccessorClassGenerator.generateMethodHandle(entity, property.getGetter())) {
                    cw.visitField(26, PropertyAccessorClassGenerator.getterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE), null, null).visitEnd();
                }
                if (!PropertyAccessorClassGenerator.generateSetterMethodHandle(entity, property.getField())) continue;
                cw.visitField(26, PropertyAccessorClassGenerator.fieldSetterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE), null, null).visitEnd();
                cw.visitField(26, PropertyAccessorClassGenerator.fieldGetterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE), null, null).visitEnd();
            }
        }

        private static void visitDefaultConstructor(PersistentEntity<?, ?> entity, String internalClassName, ClassWriter cw) {
            boolean accessibleType = PropertyAccessorClassGenerator.isAccessible(entity);
            MethodVisitor mv = accessibleType ? cw.visitMethod(1, INIT, String.format("(%s)V", ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType())), null, null) : cw.visitMethod(1, INIT, String.format("(%s)V", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT)), null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, JAVA_LANG_OBJECT, INIT, "()V", false);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)"Bean must not be null!");
            mv.visitMethodInsn(184, "org/springframework/util/Assert", "notNull", String.format("(%s%s)V", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING)), false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            if (accessibleType) {
                mv.visitFieldInsn(181, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType()));
            } else {
                mv.visitFieldInsn(181, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT));
            }
            mv.visitInsn(177);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable(THIS_REF, ClassGeneratingPropertyAccessorFactory.referenceName(internalClassName), null, l0, l3, 0);
            if (accessibleType) {
                mv.visitLocalVariable(BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(Type.getInternalName(entity.getType())), null, l0, l3, 1);
            } else {
                mv.visitLocalVariable(BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), null, l0, l3, 1);
            }
            mv.visitMaxs(2, 2);
        }

        private static void visitStaticInitializer(PersistentEntity<?, ?> entity, List<PersistentProperty<?>> persistentProperties, String internalClassName, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(8, CLINIT, "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            Label l1 = new Label();
            mv.visitLabel(l0);
            mv.visitMethodInsn(184, JAVA_LANG_INVOKE_METHOD_HANDLES, "lookup", String.format("()%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP)), false);
            mv.visitVarInsn(58, 0);
            List<Class<?>> entityClasses = PropertyAccessorClassGenerator.getPropertyDeclaratingClasses(persistentProperties);
            for (Class<?> clazz : entityClasses) {
                mv.visitLdcInsn((Object)clazz.getName());
                mv.visitMethodInsn(184, JAVA_LANG_CLASS, "forName", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_CLASS)), false);
                mv.visitVarInsn(58, PropertyAccessorClassGenerator.classVariableIndex4(entityClasses, clazz));
            }
            for (PersistentProperty persistentProperty : persistentProperties) {
                if (persistentProperty.usePropertyAccess()) {
                    if (PropertyAccessorClassGenerator.generateMethodHandle(entity, persistentProperty.getGetter())) {
                        PropertyAccessorClassGenerator.visitPropertyGetterInitializer(persistentProperty, mv, entityClasses, internalClassName);
                    }
                    if (PropertyAccessorClassGenerator.generateMethodHandle(entity, persistentProperty.getSetter())) {
                        PropertyAccessorClassGenerator.visitPropertySetterInitializer(persistentProperty, mv, entityClasses, internalClassName);
                    }
                }
                if (!PropertyAccessorClassGenerator.generateSetterMethodHandle(entity, persistentProperty.getField())) continue;
                PropertyAccessorClassGenerator.visitFieldGetterSetterInitializer(persistentProperty, mv, entityClasses, internalClassName);
            }
            mv.visitLabel(l1);
            mv.visitInsn(177);
            mv.visitLocalVariable("lookup", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP), null, l0, l1, 0);
            mv.visitLocalVariable("field", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_FIELD), null, l0, l1, 1);
            mv.visitLocalVariable("setter", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_METHOD), null, l0, l1, 2);
            mv.visitLocalVariable("getter", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_METHOD), null, l0, l1, 3);
            for (Class clazz : entityClasses) {
                int index = PropertyAccessorClassGenerator.classVariableIndex4(entityClasses, clazz);
                mv.visitLocalVariable(String.format("class_%d", index), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_CLASS), null, l0, l1, index);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static List<Class<?>> getPropertyDeclaratingClasses(List<PersistentProperty<?>> persistentProperties) {
            return persistentProperties.stream().flatMap(property -> Optionals.toStream(Optional.ofNullable(property.getField()), Optional.ofNullable(property.getGetter()), Optional.ofNullable(property.getSetter())).map(it -> ((Member)((Object)it)).getDeclaringClass())).collect(Collectors.collectingAndThen(Collectors.toSet(), it -> new ArrayList(it)));
        }

        private static void visitPropertyGetterInitializer(PersistentProperty<?> property, MethodVisitor mv, List<Class<?>> entityClasses, String internalClassName) {
            Method getter = property.getGetter();
            if (getter != null) {
                mv.visitVarInsn(25, PropertyAccessorClassGenerator.classVariableIndex4(entityClasses, getter.getDeclaringClass()));
                mv.visitLdcInsn((Object)getter.getName());
                mv.visitInsn(3);
                mv.visitTypeInsn(189, JAVA_LANG_CLASS);
                mv.visitMethodInsn(182, JAVA_LANG_CLASS, "getDeclaredMethod", String.format("(%s[%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_CLASS), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_METHOD)), false);
                mv.visitVarInsn(58, 3);
                mv.visitVarInsn(25, 3);
                mv.visitInsn(4);
                mv.visitMethodInsn(182, JAVA_LANG_REFLECT_METHOD, SET_ACCESSIBLE, "(Z)V", false);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP, "unreflect", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_METHOD), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE)), false);
            }
            if (getter == null) {
                mv.visitInsn(1);
            }
            mv.visitFieldInsn(179, internalClassName, PropertyAccessorClassGenerator.getterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
        }

        private static void visitPropertySetterInitializer(PersistentProperty<?> property, MethodVisitor mv, List<Class<?>> entityClasses, String internalClassName) {
            Method setter = property.getSetter();
            if (setter != null) {
                mv.visitVarInsn(25, PropertyAccessorClassGenerator.classVariableIndex4(entityClasses, setter.getDeclaringClass()));
                mv.visitLdcInsn((Object)setter.getName());
                mv.visitInsn(4);
                mv.visitTypeInsn(189, JAVA_LANG_CLASS);
                mv.visitInsn(89);
                mv.visitInsn(3);
                Class<?> parameterType = setter.getParameterTypes()[0];
                if (parameterType.isPrimitive()) {
                    mv.visitFieldInsn(178, Type.getInternalName((Class)ClassGeneratingPropertyAccessorFactory.autoboxType(setter.getParameterTypes()[0])), "TYPE", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_CLASS));
                } else {
                    mv.visitLdcInsn((Object)Type.getType((String)ClassGeneratingPropertyAccessorFactory.referenceName(parameterType)));
                }
                mv.visitInsn(83);
                mv.visitMethodInsn(182, JAVA_LANG_CLASS, "getDeclaredMethod", String.format("(%s[%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_CLASS), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_METHOD)), false);
                mv.visitVarInsn(58, 2);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitMethodInsn(182, JAVA_LANG_REFLECT_METHOD, SET_ACCESSIBLE, "(Z)V", false);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP, "unreflect", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_METHOD), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE)), false);
            }
            if (setter == null) {
                mv.visitInsn(1);
            }
            mv.visitFieldInsn(179, internalClassName, PropertyAccessorClassGenerator.setterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
        }

        private static void visitFieldGetterSetterInitializer(PersistentProperty<?> property, MethodVisitor mv, List<Class<?>> entityClasses, String internalClassName) {
            Field field = property.getField();
            if (field != null) {
                mv.visitVarInsn(25, PropertyAccessorClassGenerator.classVariableIndex4(entityClasses, field.getDeclaringClass()));
                mv.visitLdcInsn((Object)field.getName());
                mv.visitMethodInsn(182, JAVA_LANG_CLASS, "getDeclaredField", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_FIELD)), false);
                mv.visitVarInsn(58, 1);
                mv.visitVarInsn(25, 1);
                mv.visitInsn(4);
                mv.visitMethodInsn(182, JAVA_LANG_REFLECT_FIELD, SET_ACCESSIBLE, "(Z)V", false);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP, "unreflectGetter", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_FIELD), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE)), false);
                mv.visitFieldInsn(179, internalClassName, PropertyAccessorClassGenerator.fieldGetterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP, "unreflectSetter", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_REFLECT_FIELD), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE)), false);
                mv.visitFieldInsn(179, internalClassName, PropertyAccessorClassGenerator.fieldSetterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
            }
        }

        private static void visitBeanGetter(PersistentEntity<?, ?> entity, String internalClassName, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "getBean", String.format("()%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT)), null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            if (PropertyAccessorClassGenerator.isAccessible(entity)) {
                mv.visitFieldInsn(180, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType()));
            } else {
                mv.visitFieldInsn(180, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT));
            }
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable(THIS_REF, ClassGeneratingPropertyAccessorFactory.referenceName(internalClassName), null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }

        private static void visitGetProperty(PersistentEntity<?, ?> entity, List<PersistentProperty<?>> persistentProperties, String internalClassName, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "getProperty", "(Lorg/springframework/data/mapping/PersistentProperty;)Ljava/lang/Object;", "(Lorg/springframework/data/mapping/PersistentProperty<*>;)Ljava/lang/Object;", null);
            mv.visitCode();
            Label l0 = new Label();
            Label l1 = new Label();
            mv.visitLabel(l0);
            PropertyAccessorClassGenerator.visitAssertNotNull(mv);
            mv.visitVarInsn(25, 0);
            if (PropertyAccessorClassGenerator.isAccessible(entity)) {
                mv.visitFieldInsn(180, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType()));
            } else {
                mv.visitFieldInsn(180, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT));
            }
            mv.visitVarInsn(58, 2);
            PropertyAccessorClassGenerator.visitGetPropertySwitch(entity, persistentProperties, internalClassName, mv);
            mv.visitLabel(l1);
            PropertyAccessorClassGenerator.visitThrowUnsupportedOperationException(mv, "No accessor to get property %s");
            mv.visitLocalVariable(THIS_REF, ClassGeneratingPropertyAccessorFactory.referenceName(internalClassName), null, l0, l1, 0);
            mv.visitLocalVariable("property", ClassGeneratingPropertyAccessorFactory.referenceName(PERSISTENT_PROPERTY), "Lorg/springframework/data/mapping/PersistentProperty<*>;", l0, l1, 1);
            if (PropertyAccessorClassGenerator.isAccessible(entity)) {
                mv.visitLocalVariable(BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType()), null, l0, l1, 2);
            } else {
                mv.visitLocalVariable(BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), null, l0, l1, 2);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static void visitGetPropertySwitch(PersistentEntity<?, ?> entity, List<PersistentProperty<?>> persistentProperties, String internalClassName, MethodVisitor mv) {
            Map propertyStackMap = ClassGeneratingPropertyAccessorFactory.createPropertyStackMap(persistentProperties);
            int[] hashes = new int[propertyStackMap.size()];
            Label[] switchJumpLabels = new Label[propertyStackMap.size()];
            ArrayList stackmap = new ArrayList(propertyStackMap.values());
            Collections.sort(stackmap);
            for (int i = 0; i < stackmap.size(); ++i) {
                PropertyStackAddress propertyStackAddress = (PropertyStackAddress)stackmap.get(i);
                hashes[i] = propertyStackAddress.hash;
                switchJumpLabels[i] = propertyStackAddress.label;
            }
            Label dfltLabel = new Label();
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, PERSISTENT_PROPERTY, "getName", String.format("()%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING)), true);
            mv.visitMethodInsn(182, JAVA_LANG_STRING, "hashCode", "()I", false);
            mv.visitLookupSwitchInsn(dfltLabel, hashes, switchJumpLabels);
            for (PersistentProperty<?> property : persistentProperties) {
                mv.visitLabel(((PropertyStackAddress)propertyStackMap.get(property.getName())).label);
                mv.visitFrame(3, 0, null, 0, null);
                if (property.getGetter() != null || property.getField() != null) {
                    PropertyAccessorClassGenerator.visitGetProperty0(entity, property, mv, internalClassName);
                    continue;
                }
                mv.visitJumpInsn(167, dfltLabel);
            }
            mv.visitLabel(dfltLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }

        private static void visitGetProperty0(PersistentEntity<?, ?> entity, PersistentProperty<?> property, MethodVisitor mv, String internalClassName) {
            Method getter = property.getGetter();
            if (property.usePropertyAccess() && getter != null) {
                if (PropertyAccessorClassGenerator.generateMethodHandle(entity, getter)) {
                    mv.visitFieldInsn(178, internalClassName, PropertyAccessorClassGenerator.getterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLE, "invoke", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT)), false);
                } else {
                    mv.visitVarInsn(25, 2);
                    int invokeOpCode = 182;
                    Class<?> declaringClass = getter.getDeclaringClass();
                    boolean interfaceDefinition = declaringClass.isInterface();
                    if (interfaceDefinition) {
                        invokeOpCode = 185;
                    }
                    mv.visitMethodInsn(invokeOpCode, Type.getInternalName(declaringClass), getter.getName(), String.format("()%s", ClassGeneratingPropertyAccessorFactory.signatureTypeName(getter.getReturnType())), interfaceDefinition);
                    ClassGeneratingPropertyAccessorFactory.autoboxIfNeeded(getter.getReturnType(), ClassGeneratingPropertyAccessorFactory.autoboxType(getter.getReturnType()), mv);
                }
            } else {
                Field field = property.getRequiredField();
                if (PropertyAccessorClassGenerator.generateMethodHandle(entity, field)) {
                    mv.visitFieldInsn(178, internalClassName, PropertyAccessorClassGenerator.fieldGetterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLE, "invoke", String.format("(%s)%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT)), false);
                } else {
                    mv.visitVarInsn(25, 2);
                    mv.visitFieldInsn(180, Type.getInternalName(field.getDeclaringClass()), field.getName(), ClassGeneratingPropertyAccessorFactory.signatureTypeName(field.getType()));
                    ClassGeneratingPropertyAccessorFactory.autoboxIfNeeded(field.getType(), ClassGeneratingPropertyAccessorFactory.autoboxType(field.getType()), mv);
                }
            }
            mv.visitInsn(176);
        }

        private static void visitSetProperty(PersistentEntity<?, ?> entity, List<PersistentProperty<?>> persistentProperties, String internalClassName, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, "setProperty", "(Lorg/springframework/data/mapping/PersistentProperty;Ljava/lang/Object;)V", "(Lorg/springframework/data/mapping/PersistentProperty<*>;Ljava/lang/Object;)V", null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            PropertyAccessorClassGenerator.visitAssertNotNull(mv);
            mv.visitVarInsn(25, 0);
            if (PropertyAccessorClassGenerator.isAccessible(entity)) {
                mv.visitFieldInsn(180, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType()));
            } else {
                mv.visitFieldInsn(180, internalClassName, BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT));
            }
            mv.visitVarInsn(58, 3);
            PropertyAccessorClassGenerator.visitSetPropertySwitch(entity, persistentProperties, internalClassName, mv);
            Label l1 = new Label();
            mv.visitLabel(l1);
            PropertyAccessorClassGenerator.visitThrowUnsupportedOperationException(mv, "No accessor to set property %s");
            mv.visitLocalVariable(THIS_REF, ClassGeneratingPropertyAccessorFactory.referenceName(internalClassName), null, l0, l1, 0);
            mv.visitLocalVariable("property", "Lorg/springframework/data/mapping/PersistentProperty;", "Lorg/springframework/data/mapping/PersistentProperty<*>;", l0, l1, 1);
            mv.visitLocalVariable("value", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), null, l0, l1, 2);
            if (PropertyAccessorClassGenerator.isAccessible(entity)) {
                mv.visitLocalVariable(BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(entity.getType()), null, l0, l1, 3);
            } else {
                mv.visitLocalVariable(BEAN_FIELD, ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), null, l0, l1, 3);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static void visitSetPropertySwitch(PersistentEntity<?, ?> entity, List<PersistentProperty<?>> persistentProperties, String internalClassName, MethodVisitor mv) {
            Map propertyStackMap = ClassGeneratingPropertyAccessorFactory.createPropertyStackMap(persistentProperties);
            int[] hashes = new int[propertyStackMap.size()];
            Label[] switchJumpLabels = new Label[propertyStackMap.size()];
            ArrayList stackmap = new ArrayList(propertyStackMap.values());
            Collections.sort(stackmap);
            for (int i = 0; i < stackmap.size(); ++i) {
                PropertyStackAddress propertyStackAddress = (PropertyStackAddress)stackmap.get(i);
                hashes[i] = propertyStackAddress.hash;
                switchJumpLabels[i] = propertyStackAddress.label;
            }
            Label dfltLabel = new Label();
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, PERSISTENT_PROPERTY, "getName", String.format("()%s", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING)), true);
            mv.visitMethodInsn(182, JAVA_LANG_STRING, "hashCode", "()I", false);
            mv.visitLookupSwitchInsn(dfltLabel, hashes, switchJumpLabels);
            for (PersistentProperty<?> property : persistentProperties) {
                mv.visitLabel(((PropertyStackAddress)propertyStackMap.get(property.getName())).label);
                mv.visitFrame(3, 0, null, 0, null);
                if (property.getSetter() != null || property.getField() != null) {
                    PropertyAccessorClassGenerator.visitSetProperty0(entity, property, mv, internalClassName);
                    continue;
                }
                mv.visitJumpInsn(167, dfltLabel);
            }
            mv.visitLabel(dfltLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }

        private static void visitSetProperty0(PersistentEntity<?, ?> entity, PersistentProperty<?> property, MethodVisitor mv, String internalClassName) {
            Method setter = property.getSetter();
            if (property.usePropertyAccess() && setter != null) {
                if (PropertyAccessorClassGenerator.generateMethodHandle(entity, setter)) {
                    mv.visitFieldInsn(178, internalClassName, PropertyAccessorClassGenerator.setterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
                    mv.visitVarInsn(25, 3);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLE, "invoke", String.format("(%s%s)V", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT)), false);
                } else {
                    mv.visitVarInsn(25, 3);
                    mv.visitVarInsn(25, 2);
                    Class<?> parameterType = setter.getParameterTypes()[0];
                    mv.visitTypeInsn(192, Type.getInternalName((Class)ClassGeneratingPropertyAccessorFactory.autoboxType(parameterType)));
                    ClassGeneratingPropertyAccessorFactory.autoboxIfNeeded(ClassGeneratingPropertyAccessorFactory.autoboxType(parameterType), parameterType, mv);
                    int invokeOpCode = 182;
                    Class<?> declaringClass = setter.getDeclaringClass();
                    boolean interfaceDefinition = declaringClass.isInterface();
                    if (interfaceDefinition) {
                        invokeOpCode = 185;
                    }
                    mv.visitMethodInsn(invokeOpCode, Type.getInternalName(setter.getDeclaringClass()), setter.getName(), String.format("(%s)V", ClassGeneratingPropertyAccessorFactory.signatureTypeName(parameterType)), interfaceDefinition);
                }
            } else {
                Field field = property.getField();
                if (field != null) {
                    if (PropertyAccessorClassGenerator.generateSetterMethodHandle(entity, field)) {
                        mv.visitFieldInsn(178, internalClassName, PropertyAccessorClassGenerator.fieldSetterName(property), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_INVOKE_METHOD_HANDLE));
                        mv.visitVarInsn(25, 3);
                        mv.visitVarInsn(25, 2);
                        mv.visitMethodInsn(182, JAVA_LANG_INVOKE_METHOD_HANDLE, "invoke", String.format("(%s%s)V", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT)), false);
                    } else {
                        mv.visitVarInsn(25, 3);
                        mv.visitVarInsn(25, 2);
                        Class<?> fieldType = field.getType();
                        mv.visitTypeInsn(192, Type.getInternalName((Class)ClassGeneratingPropertyAccessorFactory.autoboxType(fieldType)));
                        ClassGeneratingPropertyAccessorFactory.autoboxIfNeeded(ClassGeneratingPropertyAccessorFactory.autoboxType(fieldType), fieldType, mv);
                        mv.visitFieldInsn(181, Type.getInternalName(field.getDeclaringClass()), field.getName(), ClassGeneratingPropertyAccessorFactory.signatureTypeName(fieldType));
                    }
                }
            }
            mv.visitInsn(177);
        }

        private static void visitAssertNotNull(MethodVisitor mv) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)"Property must not be null!");
            mv.visitMethodInsn(184, "org/springframework/util/Assert", "notNull", String.format("(%s%s)V", ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_OBJECT), ClassGeneratingPropertyAccessorFactory.referenceName(JAVA_LANG_STRING)), false);
        }

        private static void visitThrowUnsupportedOperationException(MethodVisitor mv, String message) {
            mv.visitTypeInsn(187, JAVA_LANG_UNSUPPORTED_OPERATION_EXCEPTION);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)message);
            mv.visitInsn(4);
            mv.visitTypeInsn(189, JAVA_LANG_OBJECT);
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(83);
            mv.visitMethodInsn(184, JAVA_LANG_STRING, "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            mv.visitMethodInsn(183, JAVA_LANG_UNSUPPORTED_OPERATION_EXCEPTION, INIT, "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
        }

        private static String fieldSetterName(PersistentProperty<?> property) {
            return String.format("$%s_fieldSetter", property.getName());
        }

        private static String fieldGetterName(PersistentProperty<?> property) {
            return String.format("$%s_fieldGetter", property.getName());
        }

        private static String setterName(PersistentProperty<?> property) {
            return String.format("$%s_setter", property.getName());
        }

        private static String getterName(PersistentProperty<?> property) {
            return String.format("$%s_getter", property.getName());
        }

        private static boolean isAccessible(PersistentEntity<?, ?> entity) {
            return PropertyAccessorClassGenerator.isAccessible(entity.getType());
        }

        private static boolean isAccessible(Class<?> theClass) {
            return PropertyAccessorClassGenerator.isAccessible(theClass.getModifiers());
        }

        private static boolean isAccessible(int modifiers) {
            return !Modifier.isPrivate(modifiers);
        }

        private static boolean isDefault(int modifiers) {
            return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
        }

        private static boolean generateSetterMethodHandle(PersistentEntity<?, ?> entity, @Nullable Field field) {
            if (field == null) {
                return false;
            }
            return PropertyAccessorClassGenerator.generateMethodHandle(entity, field) || Modifier.isFinal(field.getModifiers());
        }

        private static boolean generateMethodHandle(PersistentEntity<?, ?> entity, @Nullable Member member) {
            if (member == null) {
                return false;
            }
            if (PropertyAccessorClassGenerator.isAccessible(entity)) {
                if ((Modifier.isProtected(member.getModifiers()) || PropertyAccessorClassGenerator.isDefault(member.getModifiers())) && !member.getDeclaringClass().getPackage().equals(entity.getType().getPackage())) {
                    return true;
                }
                if (PropertyAccessorClassGenerator.isAccessible(member.getDeclaringClass()) && PropertyAccessorClassGenerator.isAccessible(member.getModifiers())) {
                    return false;
                }
            }
            return true;
        }

        private static int classVariableIndex4(List<Class<?>> list, Class<?> item) {
            return 4 + list.indexOf(item);
        }

        private static String generateClassName(PersistentEntity<?, ?> entity) {
            return entity.getType().getName() + TAG + Integer.toString(entity.hashCode(), 36);
        }
    }
}

