/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.springframework.util.Assert;

@FunctionalInterface
public interface MethodLookup {
    public List<MethodPredicate> getLookups();

    default public MethodLookup and(MethodLookup other) {
        Assert.notNull((Object)other, (String)"Other method lookup must not be null!");
        return () -> Stream.concat(this.getLookups().stream(), other.getLookups().stream()).collect(Collectors.toList());
    }

    public static final class InvokedMethod {
        @NonNull
        private final Method method;

        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        public String getName() {
            return this.method.getName();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        public int getParameterCount() {
            return this.method.getParameterCount();
        }

        private InvokedMethod(@NonNull Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            this.method = method;
        }

        public static InvokedMethod of(@NonNull Method method) {
            return new InvokedMethod(method);
        }

        @NonNull
        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvokedMethod)) {
                return false;
            }
            InvokedMethod other = (InvokedMethod)o;
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }

        public String toString() {
            return "MethodLookup.InvokedMethod(method=" + this.getMethod() + ")";
        }
    }

    @FunctionalInterface
    public static interface MethodPredicate
    extends BiPredicate<InvokedMethod, Method> {
        @Override
        public boolean test(InvokedMethod var1, Method var2);
    }
}

