/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.data.repository.cdi.CdiRepositoryConfiguration;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.RepositoryBeanNameGenerator;
import org.springframework.data.repository.config.SpringDataAnnotationBeanNameGenerator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class CdiRepositoryBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdiRepositoryBean.class);
    private static final CdiRepositoryConfiguration DEFAULT_CONFIGURATION = DefaultCdiRepositoryConfiguration.INSTANCE;
    private final Set<Annotation> qualifiers;
    private final Class<T> repositoryType;
    private final Optional<CustomRepositoryImplementationDetector> detector;
    private final BeanManager beanManager;
    private final String passivationId;
    @Nullable
    private transient T repoInstance;
    private final SpringDataAnnotationBeanNameGenerator annotationBeanNameGenerator = new SpringDataAnnotationBeanNameGenerator();
    private final RepositoryBeanNameGenerator beanNameGenerator = new RepositoryBeanNameGenerator(this.getClass().getClassLoader());

    public CdiRepositoryBean(Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager) {
        this(qualifiers, repositoryType, beanManager, Optional.empty());
    }

    public CdiRepositoryBean(Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, Optional<CustomRepositoryImplementationDetector> detector) {
        Assert.notNull(qualifiers, (String)"Qualifiers must not be null!");
        Assert.notNull((Object)beanManager, (String)"BeanManager must not be null!");
        Assert.notNull(repositoryType, (String)"Repoitory type must not be null!");
        Assert.isTrue((boolean)repositoryType.isInterface(), (String)"RepositoryType must be an interface!");
        this.qualifiers = qualifiers;
        this.repositoryType = repositoryType;
        this.beanManager = beanManager;
        this.detector = detector;
        this.passivationId = this.createPassivationId(qualifiers, repositoryType);
    }

    private String createPassivationId(Set<Annotation> qualifiers, Class<?> repositoryType) {
        ArrayList<String> qualifierNames = new ArrayList<String>(qualifiers.size());
        for (Annotation qualifier : qualifiers) {
            qualifierNames.add(qualifier.annotationType().getName());
        }
        Collections.sort(qualifierNames);
        return StringUtils.collectionToDelimitedString(qualifierNames, (String)":") + ":" + repositoryType.getName();
    }

    public Set<Type> getTypes() {
        HashSet interfaces = new HashSet();
        interfaces.add(this.repositoryType);
        interfaces.addAll(Arrays.asList(this.repositoryType.getInterfaces()));
        return new HashSet<Type>(interfaces);
    }

    protected <S> S getDependencyInstance(Bean<S> bean) {
        return this.getDependencyInstance(bean, bean.getBeanClass());
    }

    protected <S> S getDependencyInstance(Bean<S> bean, Class<?> type) {
        CreationalContext creationalContext = this.beanManager.createCreationalContext(bean);
        return (S)this.beanManager.getReference(bean, type, creationalContext);
    }

    public final void initialize() {
        this.create(this.beanManager.createCreationalContext((Contextual)this));
    }

    public final T create(CreationalContext<T> creationalContext) {
        T repoInstance = this.repoInstance;
        if (repoInstance != null) {
            LOGGER.debug("Returning eagerly created CDI repository instance for {}.", (Object)this.repositoryType.getName());
            return repoInstance;
        }
        LOGGER.debug("Creating CDI repository bean instance for {}.", (Object)this.repositoryType.getName());
        this.repoInstance = repoInstance = this.create(creationalContext, this.repositoryType);
        return repoInstance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Destroying bean instance %s for repository type '%s'.", instance.toString(), this.repositoryType.getName()));
        }
        creationalContext.release();
    }

    protected CdiRepositoryConfiguration lookupConfiguration(BeanManager beanManager, Set<Annotation> qualifiers) {
        return beanManager.getBeans(CdiRepositoryConfiguration.class, this.getQualifiersArray(qualifiers)).stream().findFirst().map(it -> (CdiRepositoryConfiguration)this.getDependencyInstance((Bean)it)).orElse(DEFAULT_CONFIGURATION);
    }

    private Optional<Bean<?>> getCustomImplementationBean(Class<?> repositoryType, BeanManager beanManager, Set<Annotation> qualifiers) {
        return this.detector.flatMap(it -> {
            CdiRepositoryConfiguration cdiRepositoryConfiguration = this.lookupConfiguration(beanManager, qualifiers);
            return this.getCustomImplementationClass(repositoryType, cdiRepositoryConfiguration, (CustomRepositoryImplementationDetector)it).flatMap(type -> beanManager.getBeans((Type)type, this.getQualifiersArray(qualifiers)).stream().findFirst());
        });
    }

    private Optional<Class<?>> getCustomImplementationClass(Class<?> repositoryType, CdiRepositoryConfiguration cdiRepositoryConfiguration, CustomRepositoryImplementationDetector detector) {
        String className = this.getCustomImplementationClassName(repositoryType, cdiRepositoryConfiguration);
        Optional<AbstractBeanDefinition> beanDefinition = detector.detectCustomImplementation(className, this.getCustomImplementationBeanName(repositoryType), Collections.singleton(repositoryType.getPackage().getName()), Collections.emptySet(), this.beanNameGenerator::generateBeanName);
        return beanDefinition.map(it -> {
            try {
                return Class.forName(it.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new UnsatisfiedResolutionException(String.format("Unable to resolve class for '%s'", it.getBeanClassName()), (Throwable)e);
            }
        });
    }

    private String getCustomImplementationBeanName(Class<?> repositoryType) {
        return this.annotationBeanNameGenerator.generateBeanName((BeanDefinition)new AnnotatedGenericBeanDefinition(repositoryType)) + DEFAULT_CONFIGURATION.getRepositoryImplementationPostfix();
    }

    private String getCustomImplementationClassName(Class<?> repositoryType, CdiRepositoryConfiguration cdiRepositoryConfiguration) {
        String configuredPostfix = cdiRepositoryConfiguration.getRepositoryImplementationPostfix();
        Assert.hasText((String)configuredPostfix, (String)"Configured repository postfix must not be null or empty!");
        return ClassUtils.getShortName(repositoryType) + configuredPostfix;
    }

    private Annotation[] getQualifiersArray(Set<Annotation> qualifiers) {
        return qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getName() {
        return this.repositoryType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Arrays.stream(this.repositoryType.getAnnotations()).map(Annotation::annotationType).filter(it -> it.isAnnotationPresent(Stereotype.class)).collect(Collectors.toSet());
    }

    public Class<?> getBeanClass() {
        return this.repositoryType;
    }

    public boolean isAlternative() {
        return this.repositoryType.isAnnotationPresent(Alternative.class);
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getId() {
        return this.passivationId;
    }

    @Deprecated
    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        Optional<Bean<Bean>> customImplementationBean = this.getCustomImplementationBean(repositoryType, this.beanManager, this.qualifiers);
        Optional<Object> customImplementation = customImplementationBean.map(it -> this.beanManager.getReference(it, (Type)it.getBeanClass(), this.beanManager.createCreationalContext((Contextual)it)));
        return this.create(creationalContext, repositoryType, customImplementation);
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Optional<Object> customImplementation) {
        throw new UnsupportedOperationException("You have to implement create(CreationalContext<T>, Class<T>, Optional<Object>) in order to use custom repository implementations");
    }

    public String toString() {
        return String.format("CdiRepositoryBean: type='%s', qualifiers=%s", this.repositoryType.getName(), this.qualifiers.toString());
    }

    static enum DefaultCdiRepositoryConfiguration implements CdiRepositoryConfiguration
    {
        INSTANCE;


        @Override
        public String getRepositoryImplementationPostfix() {
            return "Impl";
        }
    }
}

