/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.support;

import org.springframework.data.domain.Persistable;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.data.support.PersistableIsNewStrategy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class IsNewStrategyFactorySupport
implements IsNewStrategyFactory {
    @Override
    public final IsNewStrategy getIsNewStrategy(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        if (Persistable.class.isAssignableFrom(type)) {
            return PersistableIsNewStrategy.INSTANCE;
        }
        IsNewStrategy strategy = this.doGetIsNewStrategy(type);
        if (strategy != null) {
            return strategy;
        }
        throw new IllegalArgumentException(String.format("Unsupported entity %s! Could not determine IsNewStrategy.", type.getName()));
    }

    @Nullable
    protected abstract IsNewStrategy doGetIsNewStrategy(Class<?> var1);
}

