/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import kotlin.coroutines.Continuation;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.reactive.AwaitKt;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.lang.Nullable;

class ImplementationInvocationMetadata {
    private final boolean suspendedDeclaredMethod;
    private final boolean suspendedBaseClassMethod;
    private final boolean reactiveBaseClassMethod;

    ImplementationInvocationMetadata(Method declaredMethod, Method baseClassMethod) {
        if (!KotlinDetector.isKotlinReflectPresent()) {
            this.suspendedDeclaredMethod = false;
            this.suspendedBaseClassMethod = false;
            this.reactiveBaseClassMethod = false;
            return;
        }
        KFunction<?> declaredFunction = KotlinDetector.isKotlinType(declaredMethod.getDeclaringClass()) ? KotlinReflectionUtils.findKotlinFunction(declaredMethod) : null;
        KFunction<?> baseClassFunction = KotlinDetector.isKotlinType(baseClassMethod.getDeclaringClass()) ? KotlinReflectionUtils.findKotlinFunction(baseClassMethod) : null;
        this.suspendedDeclaredMethod = declaredFunction != null && declaredFunction.isSuspend();
        this.suspendedBaseClassMethod = baseClassFunction != null && baseClassFunction.isSuspend();
        this.reactiveBaseClassMethod = !this.suspendedBaseClassMethod && ReactiveWrapperConverters.supports(baseClassMethod.getReturnType());
    }

    @Nullable
    public Object invoke(Method methodToCall, Object instance, Object[] args) throws Throwable {
        return this.shouldAdaptReactiveToSuspended() ? this.invokeReactiveToSuspend(methodToCall, instance, args) : methodToCall.invoke(instance, args);
    }

    private boolean shouldAdaptReactiveToSuspended() {
        return this.suspendedDeclaredMethod && !this.suspendedBaseClassMethod && this.reactiveBaseClassMethod;
    }

    @Nullable
    private Object invokeReactiveToSuspend(Method methodToCall, Object instance, Object[] args) throws ReflectiveOperationException {
        Object[] invocationArguments = new Object[args.length - 1];
        System.arraycopy(args, 0, invocationArguments, 0, invocationArguments.length);
        Object result = methodToCall.invoke(instance, invocationArguments);
        Publisher publisher = result instanceof Publisher ? (Publisher)result : ReactiveWrapperConverters.toWrapper(result, Publisher.class);
        return AwaitKt.awaitFirstOrNull((Publisher)publisher, (Continuation)((Continuation)args[args.length - 1]));
    }

    boolean canInvoke(Method invokedMethod, Method backendMethod) {
        if (this.suspendedDeclaredMethod == this.suspendedBaseClassMethod) {
            return invokedMethod.getParameterCount() == backendMethod.getParameterCount();
        }
        if (this.suspendedDeclaredMethod && this.reactiveBaseClassMethod) {
            return invokedMethod.getParameterCount() - 1 == backendMethod.getParameterCount();
        }
        return false;
    }
}

