/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.Ordered;

public class KotlinBeanInfoFactory
implements BeanInfoFactory,
Ordered {
    public BeanInfo getBeanInfo(final Class<?> beanClass) throws IntrospectionException {
        if (beanClass.isInterface()) {
            return null;
        }
        if (!KotlinDetector.isKotlinReflectPresent() || !KotlinDetector.isKotlinType(beanClass)) {
            return null;
        }
        KClass kotlinClass = JvmClassMappingKt.getKotlinClass(beanClass);
        final ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        for (KCallable member : kotlinClass.getMembers()) {
            Method method;
            if (!(member instanceof KProperty)) continue;
            KProperty property = (KProperty)member;
            Method getter = ReflectJvmMapping.getJavaGetter((KProperty)property);
            if (property instanceof KMutableProperty) {
                KMutableProperty kmp = (KMutableProperty)property;
                method = ReflectJvmMapping.getJavaSetter((KMutableProperty)kmp);
            } else {
                method = null;
            }
            Method setter = method;
            pds.add(new PropertyDescriptor(property.getName(), getter, setter));
        }
        return new SimpleBeanInfo(){

            @Override
            public BeanDescriptor getBeanDescriptor() {
                return new BeanDescriptor(beanClass);
            }

            @Override
            public PropertyDescriptor[] getPropertyDescriptors() {
                return pds.toArray(new PropertyDescriptor[0]);
            }
        };
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }
}

