/*
 * Copyright 2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.repository.aot.generate;

import org.springframework.lang.CheckReturnValue;

/**
 * Name factory for generating clash free variable names checking an intended name against predefined and already used
 * ones.
 *
 * @author Christoph Strobl
 * @since 4.0
 */
interface VariableNameFactory {

	/**
	 * Compare and potentially generate a new name for the given intended variable name.
	 *
	 * @param intendedVariableName must not be {@literal null}.
	 * @return the {@literal intendedVariableName} if no naming clash detected or a clash free generated name.
	 */
	@CheckReturnValue
	String generateName(String intendedVariableName);

}
