/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;

public class PersistentEntityParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    private final PersistentEntity<?, P> entity;
    private final PropertyValueProvider<P> provider;
    private final @Nullable Object parent;

    public PersistentEntityParameterValueProvider(PersistentEntity<?, P> entity, PropertyValueProvider<P> provider, @Nullable Object parent) {
        this.entity = entity;
        this.provider = provider;
        this.parent = parent;
    }

    @Override
    public <T> @Nullable T getParameterValue(Parameter<T, P> parameter) {
        InstanceCreatorMetadata<P> creator = this.entity.getInstanceCreatorMetadata();
        if (creator != null && creator.isParentParameter(parameter)) {
            return (T)this.parent;
        }
        String name = parameter.getName();
        if (name == null) {
            throw new MappingException(String.format("Parameter %s does not have a name", parameter));
        }
        P property = this.entity.getPersistentProperty(name);
        if (property == null) {
            throw new MappingException(String.format("No property %s found on entity %s to bind constructor parameter to", name, this.entity.getType()));
        }
        return this.provider.getPropertyValue(property);
    }
}

