/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

public class SimpleTypeInformationMapper
implements TypeInformationMapper,
BeanClassLoaderAware {
    private final Map<String, Optional<TypeInformation<?>>> cache = new ConcurrentHashMap();
    private @Nullable ClassLoader classLoader;

    @Override
    public @Nullable TypeInformation<?> resolveTypeFrom(Alias alias) {
        String stringAlias = alias.mapTyped(String.class);
        if (stringAlias != null) {
            return this.cache.computeIfAbsent(stringAlias, this::loadClass).orElse(null);
        }
        return null;
    }

    @Override
    public Alias createAliasFor(TypeInformation<?> type) {
        return Alias.of(type.getType().getName());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Optional<TypeInformation<?>> loadClass(String typeName) {
        try {
            return Optional.of(TypeInformation.of(ClassUtils.forName((String)typeName, (ClassLoader)this.classLoader)));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

