/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.javapoet;

import java.lang.reflect.Type;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;

public abstract class TypeNames {
    public static TypeName classNameOrWrapper(Class<?> type) {
        return ClassUtils.isPrimitiveOrWrapper(type) ? TypeName.get((Type)ClassUtils.resolvePrimitiveIfNecessary(type)) : TypeName.get(type);
    }

    public static TypeName classNameOrWrapper(ResolvableType resolvableType) {
        return TypeNames.classNameOrWrapper(resolvableType.toClass());
    }

    public static TypeName className(ResolvableType resolvableType) {
        return TypeName.get((Type)resolvableType.toClass());
    }

    public static TypeName typeName(ResolvableType resolvableType) {
        return TypeName.get((Type)resolvableType.getType());
    }

    public static TypeName typeNameOrWrapper(Class<?> type) {
        return TypeNames.typeNameOrWrapper(ResolvableType.forClass(type));
    }

    public static TypeName typeNameOrWrapper(ResolvableType resolvableType) {
        return ClassUtils.isPrimitiveOrWrapper((Class)resolvableType.toClass()) ? TypeName.get((Type)ClassUtils.resolvePrimitiveIfNecessary((Class)resolvableType.toClass())) : TypeNames.typeName(resolvableType);
    }

    private TypeNames() {
    }
}

