/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;

public interface ValueConversionContext<P extends PersistentProperty<P>> {
    public P getProperty();

    default public @Nullable Object write(@Nullable Object value) {
        return this.write(value, this.getProperty().getTypeInformation());
    }

    default public <T> @Nullable T write(@Nullable Object value, Class<T> target) {
        return this.write(value, TypeInformation.of(target));
    }

    default public <T> @Nullable T write(@Nullable Object value, TypeInformation<T> target) {
        if (value == null || target.getType().isInstance(value)) {
            return target.getType().cast(value);
        }
        throw new IllegalStateException(String.format("%s does not provide write function that allows value conversion to target type (%s)", this.getClass(), target));
    }

    default public @Nullable Object read(@Nullable Object value) {
        return this.read(value, this.getProperty().getTypeInformation());
    }

    default public <T> @Nullable T read(@Nullable Object value, Class<T> target) {
        return this.read(value, TypeInformation.of(target));
    }

    default public <T> @Nullable T read(@Nullable Object value, TypeInformation<T> target) {
        if (value == null || target.getType().isInstance(value)) {
            return target.getType().cast(value);
        }
        throw new IllegalStateException(String.format("%s does not provide read function that allows value conversion to target type (%s)", this.getClass(), target));
    }
}

