/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import com.couchbase.client.CouchbaseClient;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class CouchbaseCache
implements Cache {
    private final CouchbaseClient client;
    private final String name;
    private final int ttl;

    public CouchbaseCache(String name, CouchbaseClient client) {
        this.name = name;
        this.client = client;
        this.ttl = 0;
    }

    public CouchbaseCache(String name, CouchbaseClient client, int ttl) {
        this.name = name;
        this.client = client;
        this.ttl = ttl;
    }

    public final String getName() {
        return this.name;
    }

    public final CouchbaseClient getNativeCache() {
        return this.client;
    }

    public final int getTtl() {
        return this.ttl;
    }

    public final Cache.ValueWrapper get(Object key) {
        String documentId = key.toString();
        Object result = this.client.get(documentId);
        return result != null ? new SimpleValueWrapper(result) : null;
    }

    public final <T> T get(Object key, Class<T> clazz) {
        String documentId = key.toString();
        return (T)this.client.get(documentId);
    }

    public final void put(Object key, Object value) {
        if (value != null) {
            String documentId = key.toString();
            this.client.set(documentId, this.ttl, value);
        } else {
            this.evict(key);
        }
    }

    public final void evict(Object key) {
        String documentId = key.toString();
        this.client.delete(documentId);
    }

    public final void clear() {
        this.client.flush();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (this.get(key) == null) {
            this.put(key, value);
            return null;
        }
        return new SimpleValueWrapper(value);
    }
}

