/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import com.couchbase.client.CouchbaseClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.data.couchbase.cache.CouchbaseCache;

public class CouchbaseCacheManager
extends AbstractCacheManager {
    private final HashMap<String, CouchbaseClient> clients;
    private final HashMap<String, Integer> ttlConfiguration;

    public CouchbaseCacheManager(HashMap<String, CouchbaseClient> clients) {
        this.clients = clients;
        this.ttlConfiguration = new HashMap();
    }

    public CouchbaseCacheManager(HashMap<String, CouchbaseClient> clients, HashMap<String, Integer> ttlConfiguration) {
        this.clients = clients;
        this.ttlConfiguration = ttlConfiguration;
    }

    public final HashMap<String, CouchbaseClient> getClients() {
        return this.clients;
    }

    protected final Collection<? extends Cache> loadCaches() {
        LinkedHashSet<CouchbaseCache> caches = new LinkedHashSet<CouchbaseCache>();
        for (Map.Entry<String, CouchbaseClient> cache : this.clients.entrySet()) {
            caches.add(new CouchbaseCache(cache.getKey(), cache.getValue(), this.getTtl(cache.getKey())));
        }
        return caches;
    }

    private int getTtl(String name) {
        Integer expirationTime = this.ttlConfiguration.get(name);
        return expirationTime != null ? expirationTime : 0;
    }
}

