/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.monitor;

import com.couchbase.client.CouchbaseClient;
import java.net.SocketAddress;
import org.springframework.data.couchbase.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Client Information")
public class ClientInfo
extends AbstractMonitor {
    public ClientInfo(CouchbaseClient client) {
        super(client);
    }

    @ManagedAttribute(description="Hostnames of connected nodes")
    public String getHostNames() {
        StringBuilder result = new StringBuilder();
        for (SocketAddress node : this.getStats().keySet()) {
            result.append(node.toString()).append(",");
        }
        return result.toString();
    }

    @ManagedAttribute(description="Number of connected nodes")
    public int getNumberOfNodes() {
        return this.getStats().keySet().size();
    }

    @ManagedAttribute(description="Number of connected active nodes")
    public int getNumberOfActiveNodes() {
        return this.getClient().getAvailableServers().size();
    }

    @ManagedAttribute(description="Number of connected inactive nodes")
    public int getNumberOfInactiveNodes() {
        return this.getClient().getUnavailableServers().size();
    }
}

