/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ViewBasedCouchbaseQuery;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.SimpleCouchbaseRepository;
import org.springframework.data.couchbase.repository.support.ViewPostProcessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class CouchbaseRepositoryFactory
extends RepositoryFactorySupport {
    private final CouchbaseOperations couchbaseOperations;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final ViewPostProcessor viewPostProcessor;

    public CouchbaseRepositoryFactory(CouchbaseOperations couchbaseOperations) {
        Assert.notNull((Object)couchbaseOperations);
        this.couchbaseOperations = couchbaseOperations;
        this.mappingContext = couchbaseOperations.getConverter().getMappingContext();
        this.viewPostProcessor = ViewPostProcessor.INSTANCE;
        this.addRepositoryProxyPostProcessor(this.viewPostProcessor);
    }

    public <T, ID extends Serializable> CouchbaseEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s!", domainClass.getName()));
        }
        return new MappingCouchbaseEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        SimpleCouchbaseRepository simpleCouchbaseRepository = new SimpleCouchbaseRepository(entityInformation, this.couchbaseOperations);
        simpleCouchbaseRepository.setViewMetadataProvider(this.viewPostProcessor.getViewMetadataProvider());
        return simpleCouchbaseRepository;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleCouchbaseRepository.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new CouchbaseQueryLookupStrategy();
    }

    private class CouchbaseQueryLookupStrategy
    implements QueryLookupStrategy {
        private CouchbaseQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            CouchbaseQueryMethod queryMethod = new CouchbaseQueryMethod(method, metadata, CouchbaseRepositoryFactory.this.mappingContext);
            return new ViewBasedCouchbaseQuery(queryMethod, CouchbaseRepositoryFactory.this.couchbaseOperations);
        }
    }
}

