/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class CouchbaseRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private CouchbaseOperations operations;

    public void setCouchbaseOperations(CouchbaseOperations operations) {
        this.operations = operations;
        this.setMappingContext(operations.getConverter().getMappingContext());
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.operations);
    }

    private RepositoryFactorySupport getFactoryInstance(CouchbaseOperations operations) {
        return new CouchbaseRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.operations, (String)"CouchbaseTemplate must not be null!");
    }
}

