/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.couchbase.config.CouchbaseEnvironmentNoShutdownProxy;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.convert.CustomConversions;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.couchbase.core.query.Consistency;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.IndexManager;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractCouchbaseConfiguration {
    protected abstract List<String> getBootstrapHosts();

    protected abstract String getBucketName();

    protected abstract String getBucketPassword();

    protected boolean isEnvironmentManagedBySpring() {
        return true;
    }

    protected CouchbaseEnvironment getEnvironment() {
        return DefaultCouchbaseEnvironment.create();
    }

    @Bean(destroyMethod="shutdown", name={"couchbaseEnv"})
    public CouchbaseEnvironment couchbaseEnvironment() {
        CouchbaseEnvironment env = this.getEnvironment();
        if (this.isEnvironmentManagedBySpring()) {
            return env;
        }
        return new CouchbaseEnvironmentNoShutdownProxy(env);
    }

    @Bean(destroyMethod="disconnect", name={"couchbaseCluster"})
    public Cluster couchbaseCluster() throws Exception {
        return CouchbaseCluster.create((CouchbaseEnvironment)this.couchbaseEnvironment(), this.getBootstrapHosts());
    }

    @Bean(name={"couchbaseClusterInfo"})
    public ClusterInfo couchbaseClusterInfo() throws Exception {
        return this.couchbaseCluster().clusterManager(this.getBucketName(), this.getBucketPassword()).info();
    }

    @Bean(destroyMethod="close", name={"couchbaseBucket"})
    public Bucket couchbaseClient() throws Exception {
        return this.couchbaseCluster().openBucket(this.getBucketName(), this.getBucketPassword());
    }

    @Bean(name={"couchbaseTemplate"})
    public CouchbaseTemplate couchbaseTemplate() throws Exception {
        CouchbaseTemplate template = new CouchbaseTemplate(this.couchbaseClusterInfo(), this.couchbaseClient(), this.mappingCouchbaseConverter(), this.translationService());
        template.setDefaultConsistency(this.getDefaultConsistency());
        return template;
    }

    @Bean(name={"couchbaseRepositoryOperationsMapping"})
    public RepositoryOperationsMapping repositoryOperationsMapping() throws Exception {
        RepositoryOperationsMapping baseMapping = new RepositoryOperationsMapping(this.couchbaseTemplate());
        this.configureRepositoryOperationsMapping(baseMapping);
        return baseMapping;
    }

    protected void configureRepositoryOperationsMapping(RepositoryOperationsMapping mapping) {
    }

    public String typeKey() {
        return "_class";
    }

    @Bean(name={"couchbaseMappingConverter"})
    public MappingCouchbaseConverter mappingCouchbaseConverter() throws Exception {
        MappingCouchbaseConverter converter = new MappingCouchbaseConverter((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)this.couchbaseMappingContext(), this.typeKey());
        converter.setCustomConversions(this.customConversions());
        return converter;
    }

    @Bean(name={"couchbaseTranslationService"})
    public TranslationService translationService() {
        JacksonTranslationService jacksonTranslationService = new JacksonTranslationService();
        jacksonTranslationService.afterPropertiesSet();
        return jacksonTranslationService;
    }

    @Bean(name={"couchbaseMappingContext"})
    public CouchbaseMappingContext couchbaseMappingContext() throws Exception {
        CouchbaseMappingContext mappingContext = new CouchbaseMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(this.customConversions().getSimpleTypeHolder());
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        return mappingContext;
    }

    @Bean(name={"couchbaseCustomConversions"})
    public CustomConversions customConversions() {
        return new CustomConversions(Collections.emptyList());
    }

    @Bean(name={"couchbaseIndexManager"})
    public IndexManager indexManager() {
        return new IndexManager(false, false, false);
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        String basePackage = this.getMappingBasePackage();
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)AbstractCouchbaseConfiguration.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    protected String getMappingBasePackage() {
        return this.getClass().getPackage().getName();
    }

    protected boolean abbreviateFieldNames() {
        return false;
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return this.abbreviateFieldNames() ? new CamelCaseAbbreviatingFieldNamingStrategy() : PropertyNameFieldNamingStrategy.INSTANCE;
    }

    protected Consistency getDefaultConsistency() {
        return Consistency.DEFAULT_CONSISTENCY;
    }
}

