/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.cdi.CouchbaseRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class CouchbaseRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private final Map<String, Bean<CouchbaseOperations>> couchbaseOperationsMap = new HashMap<String, Bean<CouchbaseOperations>>();

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !CouchbaseOperations.class.isAssignableFrom((Class)type)) continue;
            this.couchbaseOperationsMap.put(bean.getQualifiers().toString(), (Bean<CouchbaseOperations>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            afterBeanDiscovery.addBean(repositoryBean);
            this.registerBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<CouchbaseOperations> couchbaseOperationsBean = this.couchbaseOperationsMap.get(qualifiers.toString());
        if (couchbaseOperationsBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", CouchbaseOperations.class.getName(), qualifiers));
        }
        return new CouchbaseRepositoryBean<T>(couchbaseOperationsBean, qualifiers, repositoryType, beanManager, this.getCustomImplementationDetector());
    }
}

