/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.AggregateFunctions;
import com.couchbase.client.java.query.dsl.functions.MetaFunctions;
import com.couchbase.client.java.query.dsl.path.FromPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.util.ArrayList;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.core.EntityMetadata;

public class N1qlUtils {
    public static final Converter<? super CouchbasePersistentProperty, String> FIELD_NAME_ESCAPED = new Converter<CouchbasePersistentProperty, String>(){

        public String convert(CouchbasePersistentProperty source) {
            return "`" + source.getFieldName() + "`";
        }
    };

    public static Expression escapedBucket(String bucketName) {
        return Expression.i((String[])new String[]{bucketName});
    }

    public static FromPath createSelectClauseForEntity(String bucketName) {
        Expression bucket = N1qlUtils.escapedBucket(bucketName);
        Expression metaId = Expression.path((Object[])new Object[]{MetaFunctions.meta((Expression)bucket), "id"}).as("_ID");
        Expression metaCas = Expression.path((Object[])new Object[]{MetaFunctions.meta((Expression)bucket), "cas"}).as("_CAS");
        return Select.select((Expression[])new Expression[]{metaId, metaCas, Expression.path((Object[])new Object[]{bucket, "*"})});
    }

    public static WherePath createSelectFromForEntity(String bucketName) {
        return N1qlUtils.createSelectClauseForEntity(bucketName).from(N1qlUtils.escapedBucket(bucketName));
    }

    public static Expression createWhereFilterForEntity(Expression baseWhereCriteria, CouchbaseConverter converter, EntityMetadata<?> entityInformation) {
        String typeKey = converter.getTypeKey();
        String typeValue = entityInformation.getJavaType().getName();
        Expression typeSelector = Expression.i((String[])new String[]{typeKey}).eq(Expression.s((String[])new String[]{typeValue}));
        baseWhereCriteria = baseWhereCriteria == null ? typeSelector : baseWhereCriteria.and(typeSelector);
        return baseWhereCriteria;
    }

    public static PersistentPropertyPath<CouchbasePersistentProperty> getPathWithAlternativeFieldNames(CouchbaseConverter converter, PropertyPath property) {
        PersistentPropertyPath path = converter.getMappingContext().getPersistentPropertyPath(property);
        return path;
    }

    public static String getDottedPathWithAlternativeFieldNames(PersistentPropertyPath<CouchbasePersistentProperty> path) {
        return path.toDotPath(FIELD_NAME_ESCAPED);
    }

    public static com.couchbase.client.java.query.dsl.Sort[] createSort(Sort sort, CouchbaseConverter converter) {
        ArrayList<com.couchbase.client.java.query.dsl.Sort> cbSortList = new ArrayList<com.couchbase.client.java.query.dsl.Sort>();
        for (Sort.Order order : sort) {
            String orderProperty = order.getProperty();
            Expression orderFieldName = Expression.i((String[])new String[]{orderProperty});
            if (order.isAscending()) {
                cbSortList.add(com.couchbase.client.java.query.dsl.Sort.asc((Expression)orderFieldName));
                continue;
            }
            cbSortList.add(com.couchbase.client.java.query.dsl.Sort.desc((Expression)orderFieldName));
        }
        return cbSortList.toArray(new com.couchbase.client.java.query.dsl.Sort[cbSortList.size()]);
    }

    public static <T> Statement createCountQueryForEntity(String bucketName, CouchbaseConverter converter, CouchbaseEntityInformation<T, String> entityInformation) {
        return Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*").as("count")}).from(N1qlUtils.escapedBucket(bucketName)).where(N1qlUtils.createWhereFilterForEntity(null, converter, entityInformation));
    }
}

