/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.Index;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.path.index.IndexType;
import com.couchbase.client.java.query.dsl.path.index.WithPath;
import com.couchbase.client.java.view.DefaultView;
import com.couchbase.client.java.view.DesignDocument;
import com.couchbase.client.java.view.View;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.core.query.N1qlPrimaryIndexed;
import org.springframework.data.couchbase.core.query.N1qlSecondaryIndexed;
import org.springframework.data.couchbase.core.query.ViewIndexed;
import org.springframework.data.repository.core.RepositoryInformation;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class IndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexManager.class);
    private static final String TEMPLATE_MAP_FUNCTION = "function (doc, meta) { if(doc.%s == \"%s\") { emit(meta.id, null); } }";
    private static final JsonObject SUCCESS_MARKER = JsonObject.empty();
    private boolean ignoreViews;
    private boolean ignoreN1qlPrimary;
    private boolean ignoreN1qlSecondary;

    public IndexManager(boolean processViews, boolean processN1qlPrimary, boolean processN1qlSecondary) {
        this.ignoreViews = !processViews;
        this.ignoreN1qlPrimary = !processN1qlPrimary;
        this.ignoreN1qlSecondary = !processN1qlSecondary;
    }

    public IndexManager() {
        this(true, true, true);
    }

    public boolean isIgnoreViews() {
        return this.ignoreViews;
    }

    public boolean isIgnoreN1qlPrimary() {
        return this.ignoreN1qlPrimary;
    }

    public boolean isIgnoreN1qlSecondary() {
        return this.ignoreN1qlSecondary;
    }

    public void buildIndexes(RepositoryInformation metadata, ViewIndexed viewIndexed, N1qlPrimaryIndexed n1qlPrimaryIndexed, N1qlSecondaryIndexed n1qlSecondaryIndexed, CouchbaseOperations couchbaseOperations) {
        Observable<Void> viewAsync = Observable.empty();
        Observable<Void> n1qlPrimaryAsync = Observable.empty();
        Observable<Void> n1qlSecondaryAsync = Observable.empty();
        if (viewIndexed != null && !this.ignoreViews) {
            viewAsync = this.buildAllView(viewIndexed, metadata, couchbaseOperations);
        }
        if (n1qlPrimaryIndexed != null && !this.ignoreN1qlPrimary) {
            n1qlPrimaryAsync = this.buildN1qlPrimary(metadata, couchbaseOperations);
        }
        if (n1qlSecondaryIndexed != null && !this.ignoreN1qlSecondary) {
            n1qlSecondaryAsync = this.buildN1qlSecondary(n1qlSecondaryIndexed, metadata, couchbaseOperations);
        }
        Observable.mergeDelayError((Observable)viewAsync, (Observable)n1qlPrimaryAsync, (Observable)n1qlSecondaryAsync).toBlocking().lastOrDefault(null);
    }

    private Observable<Void> buildN1qlPrimary(final RepositoryInformation metadata, CouchbaseOperations couchbaseOperations) {
        final String bucketName = couchbaseOperations.getCouchbaseBucket().name();
        WithPath createPrimary = Index.createPrimaryIndex().on(bucketName).using(IndexType.GSI);
        LOGGER.debug("Creating N1QL primary index for repository {}", (Object)metadata.getRepositoryInterface().getSimpleName());
        return couchbaseOperations.getCouchbaseBucket().async().query((Statement)createPrimary).flatMap((Func1)new Func1<AsyncN1qlQueryResult, Observable<JsonObject>>(){

            public Observable<JsonObject> call(AsyncN1qlQueryResult asyncN1qlQueryResult) {
                return asyncN1qlQueryResult.errors();
            }
        }).defaultIfEmpty((Object)SUCCESS_MARKER).flatMap((Func1)new Func1<JsonObject, Observable<Void>>(){

            public Observable<Void> call(JsonObject json) {
                if (json == SUCCESS_MARKER) {
                    LOGGER.debug("N1QL primary index created for repository {}", (Object)metadata.getRepositoryInterface().getSimpleName());
                    return Observable.empty();
                }
                if (json.getString("msg").contains("Index #primary already exist")) {
                    LOGGER.debug("Primary index already exist, skipping");
                    return Observable.empty();
                }
                return Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Cannot create N1QL primary index on " + bucketName + ": " + json)));
            }
        });
    }

    private Observable<Void> buildN1qlSecondary(N1qlSecondaryIndexed config, final RepositoryInformation metadata, CouchbaseOperations couchbaseOperations) {
        final String bucketName = couchbaseOperations.getCouchbaseBucket().name();
        final String indexName = config.indexName();
        String typeKey = couchbaseOperations.getConverter().getTypeKey();
        final String type = metadata.getDomainType().getName();
        WithPath createIndex = Index.createIndex((String)indexName).on(bucketName, Expression.x((String)typeKey), new Expression[0]).where(Expression.x((String)typeKey).eq(Expression.s((String[])new String[]{type}))).using(IndexType.GSI);
        LOGGER.debug("Creating N1QL secondary index for repository {}", (Object)metadata.getRepositoryInterface().getSimpleName());
        return couchbaseOperations.getCouchbaseBucket().async().query((Statement)createIndex).flatMap((Func1)new Func1<AsyncN1qlQueryResult, Observable<JsonObject>>(){

            public Observable<JsonObject> call(AsyncN1qlQueryResult asyncN1qlQueryResult) {
                return asyncN1qlQueryResult.errors();
            }
        }).defaultIfEmpty((Object)SUCCESS_MARKER).flatMap((Func1)new Func1<JsonObject, Observable<Void>>(){

            public Observable<Void> call(JsonObject json) {
                if (json == SUCCESS_MARKER) {
                    LOGGER.debug("N1QL secondary index created for repository {}", (Object)metadata.getRepositoryInterface().getSimpleName());
                    return Observable.empty();
                }
                if (json.getString("msg").contains("Index " + indexName + " already exist")) {
                    LOGGER.debug("Secondary index already exist, skipping");
                    return Observable.empty();
                }
                return Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Cannot create N1QL secondary index " + bucketName + "." + indexName + " for " + type + ": " + json)));
            }
        });
    }

    private Observable<Void> buildAllView(ViewIndexed config, final RepositoryInformation metadata, CouchbaseOperations couchbaseOperations) {
        String reduceFunction;
        if (config == null) {
            return Observable.empty();
        }
        LOGGER.debug("Creating View index index for repository {}", (Object)metadata.getRepositoryInterface().getSimpleName());
        BucketManager manager = couchbaseOperations.getCouchbaseBucket().bucketManager();
        String viewName = config.viewName();
        String mapFunction = config.mapFunction();
        if (mapFunction.isEmpty()) {
            String typeKey = couchbaseOperations.getConverter().getTypeKey();
            String type = metadata.getDomainType().getName();
            mapFunction = String.format(TEMPLATE_MAP_FUNCTION, typeKey, type);
        }
        if ("".equals(reduceFunction = config.reduceFunction())) {
            reduceFunction = null;
        }
        View view = DefaultView.create((String)viewName, (String)mapFunction, (String)reduceFunction);
        DesignDocument doc = manager.getDesignDocument(config.designDoc());
        if (doc != null) {
            for (View existingView : doc.views()) {
                if (!existingView.name().equals(viewName)) continue;
                LOGGER.debug("View index {}/{} already exist, skipping", (Object)config.designDoc(), (Object)viewName);
                return Observable.empty();
            }
            doc.views().add(view);
        } else {
            doc = DesignDocument.create((String)config.designDoc(), Collections.singletonList(view));
        }
        return manager.async().upsertDesignDocument(doc).map((Func1)new Func1<DesignDocument, Void>(){

            public Void call(DesignDocument designDocument) {
                return null;
            }
        }).doOnNext((Action1)new Action1<Void>(){

            public void call(Void aVoid) {
                LOGGER.debug("View index created for repository {}", (Object)metadata.getRepositoryInterface().getSimpleName());
            }
        });
    }
}

