/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.PatternMatchingFunctions;
import com.couchbase.client.java.query.dsl.functions.StringFunctions;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.ConvertingIterator;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlQueryCreator
extends AbstractQueryCreator<LimitPath, Expression> {
    private final WherePath selectFrom;
    private final CouchbaseConverter converter;
    private final CouchbaseQueryMethod queryMethod;
    private final ParameterAccessor accessor;

    public N1qlQueryCreator(PartTree tree, ParameterAccessor parameters, WherePath selectFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, parameters);
        this.selectFrom = selectFrom;
        this.converter = converter;
        this.queryMethod = queryMethod;
        this.accessor = parameters;
    }

    protected Expression create(Part part, Iterator<Object> iterator) {
        return this.prepareExpression(part, iterator);
    }

    protected Expression and(Part part, Expression base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        return base.and(this.create(part, iterator));
    }

    protected Expression or(Expression base, Expression criteria) {
        return base.or(criteria);
    }

    protected LimitPath complete(Expression criteria, Sort sort) {
        Pageable pageable;
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(criteria, this.converter, this.queryMethod.getEntityInformation());
        GroupByPath selectFromWhere = this.selectFrom.where(whereCriteria);
        if ((this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) && this.accessor.getPageable() != null && (pageable = this.accessor.getPageable()).getSort() != null) {
            sort = pageable.getSort();
        }
        if (sort != null) {
            com.couchbase.client.java.query.dsl.Sort[] cbSorts = N1qlUtils.createSort(sort, this.converter);
            return selectFromWhere.orderBy(cbSorts);
        }
        return selectFromWhere;
    }

    protected Expression prepareExpression(Part part, Iterator<Object> iterator) {
        boolean isString;
        PersistentPropertyPath<CouchbasePersistentProperty> path = N1qlUtils.getPathWithAlternativeFieldNames(this.converter, part.getProperty());
        ConvertingIterator parameterValues = new ConvertingIterator(iterator, this.converter);
        String fieldNamePath = N1qlUtils.getDottedPathWithAlternativeFieldNames(path);
        boolean ignoreCase = false;
        Class<?> leafType = this.converter.getWriteClassFor(((CouchbasePersistentProperty)path.getLeafProperty()).getType());
        boolean bl = isString = leafType == String.class;
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE) {
            ignoreCase = isString;
        } else if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
            if (!isString) {
                throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", fieldNamePath, leafType));
            }
            ignoreCase = true;
        }
        return N1qlQueryCreator.createExpression(part.getType(), fieldNamePath, ignoreCase, parameterValues);
    }

    protected static Expression createExpression(Part.Type partType, String fieldNamePath, boolean ignoreCase, Iterator<Object> parameterValues) {
        Expression left = ignoreCase ? StringFunctions.lower((Expression)Expression.x((String)fieldNamePath)) : Expression.x((String)fieldNamePath);
        switch (partType) {
            case BETWEEN: {
                return left.between(N1qlQueryCreator.leftAndRight(parameterValues, ignoreCase));
            }
            case IS_NOT_NULL: {
                return left.isNotNull();
            }
            case IS_NULL: {
                return left.isNull();
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return left.ne(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case SIMPLE_PROPERTY: {
                return left.eq(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case BEFORE: 
            case LESS_THAN: {
                return left.lt(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case LESS_THAN_EQUAL: {
                return left.lte(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case GREATER_THAN_EQUAL: {
                return left.gte(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case AFTER: 
            case GREATER_THAN: {
                return left.gt(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case NOT_LIKE: {
                return left.notLike(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case LIKE: {
                return left.like(N1qlQueryCreator.right(parameterValues, ignoreCase));
            }
            case STARTING_WITH: {
                return left.like(N1qlQueryCreator.like(parameterValues, ignoreCase, false, true));
            }
            case ENDING_WITH: {
                return left.like(N1qlQueryCreator.like(parameterValues, ignoreCase, true, false));
            }
            case NOT_CONTAINING: {
                return left.notLike(N1qlQueryCreator.like(parameterValues, ignoreCase, true, true));
            }
            case CONTAINING: {
                return left.like(N1qlQueryCreator.like(parameterValues, ignoreCase, true, true));
            }
            case NOT_IN: {
                return left.notIn(N1qlQueryCreator.rightArray(parameterValues));
            }
            case IN: {
                return left.in(N1qlQueryCreator.rightArray(parameterValues));
            }
            case TRUE: {
                return left.eq(true);
            }
            case FALSE: {
                return left.eq(false);
            }
            case REGEX: {
                return N1qlQueryCreator.regexp(fieldNamePath, parameterValues);
            }
            case EXISTS: {
                return left.isNotMissing();
            }
        }
        throw new IllegalArgumentException("Unsupported keyword in N1QL query derivation");
    }

    protected static Expression regexp(String left, Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        String pattern = next == null ? "" : String.valueOf(next);
        return PatternMatchingFunctions.regexpLike((String)left, (String)pattern);
    }

    protected static Expression leftAndRight(Iterator<Object> parameterValues, boolean ignoreCase) {
        return N1qlQueryCreator.right(parameterValues, ignoreCase).and(N1qlQueryCreator.right(parameterValues, ignoreCase));
    }

    protected static Expression like(Iterator<Object> parameterValues, boolean ignoreCase, boolean anyPrefix, boolean anySuffix) {
        Expression converted;
        Object next = parameterValues.next();
        if (next == null) {
            return Expression.NULL();
        }
        if (next instanceof String) {
            String pattern = (String)next;
            if (anyPrefix) {
                pattern = "%" + pattern;
            }
            if (anySuffix) {
                pattern = pattern + "%";
            }
            converted = Expression.s((String[])new String[]{pattern});
        } else {
            converted = Expression.x((String)String.valueOf(next));
        }
        if (ignoreCase) {
            return StringFunctions.lower((Expression)converted);
        }
        return converted;
    }

    protected static Expression right(Iterator<Object> parameterValues, boolean ignoreCase) {
        Object next = parameterValues.next();
        if (next == null) {
            return Expression.NULL();
        }
        Expression converted = next instanceof String ? Expression.s((String[])new String[]{(String)next}) : Expression.x((String)String.valueOf(next));
        if (ignoreCase) {
            return StringFunctions.lower((Expression)converted);
        }
        return converted;
    }

    protected static JsonArray rightArray(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        Object[] values = next instanceof Collection ? ((Collection)next).toArray() : (next.getClass().isArray() ? (Object[])next : new Object[]{next});
        return JsonArray.from((Object[])values);
    }
}

