/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.AggregateFunctions;
import com.couchbase.client.java.query.dsl.path.AsPath;
import com.couchbase.client.java.query.dsl.path.FromPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.query.AbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class PartTreeN1qlBasedQuery
extends AbstractN1qlBasedQuery {
    private final PartTree partTree;

    public PartTreeN1qlBasedQuery(CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations) {
        super(queryMethod, couchbaseOperations);
        this.partTree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return JsonArray.empty();
    }

    @Override
    protected Statement getCount(ParameterAccessor accessor, Object[] runtimeParameters) {
        Expression bucket = Expression.i((String[])new String[]{this.getCouchbaseOperations().getCouchbaseBucket().name()});
        AsPath countFrom = Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*").as("count")}).from(bucket);
        N1qlQueryCreator queryCreator = new N1qlQueryCreator(this.partTree, accessor, (WherePath)countFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        return (Statement)queryCreator.createQuery();
    }

    @Override
    protected Statement getStatement(ParameterAccessor accessor, Object[] runtimeParameters) {
        String bucketName = this.getCouchbaseOperations().getCouchbaseBucket().name();
        Expression bucket = N1qlUtils.escapedBucket(bucketName);
        FromPath select = this.partTree.isCountProjection() != false ? Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*")}) : N1qlUtils.createSelectClauseForEntity(bucketName);
        AsPath selectFrom = select.from(bucket);
        N1qlQueryCreator queryCreator = new N1qlQueryCreator(this.partTree, accessor, (WherePath)selectFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        LimitPath selectFromWhereOrderBy = (LimitPath)queryCreator.createQuery();
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable = accessor.getPageable();
            Assert.notNull((Object)pageable);
            return selectFromWhereOrderBy.limit(pageable.getPageSize()).offset(pageable.getOffset());
        }
        if (this.queryMethod.isSliceQuery() && accessor.getPageable() != null) {
            Pageable pageable = accessor.getPageable();
            Assert.notNull((Object)pageable);
            return selectFromWhereOrderBy.limit(pageable.getPageSize() + 1).offset(pageable.getOffset());
        }
        if (this.partTree.isLimiting()) {
            return selectFromWhereOrderBy.limit(this.partTree.getMaxResults().intValue());
        }
        return selectFromWhereOrderBy;
    }

    @Override
    protected boolean useGeneratedCountQuery() {
        return false;
    }
}

