/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.CouchbasePagingAndSortingRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.CountFragment;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.couchbase.repository.support.SimpleCouchbaseRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class N1qlCouchbaseRepository<T, ID extends Serializable>
extends SimpleCouchbaseRepository<T, ID>
implements CouchbasePagingAndSortingRepository<T, ID> {
    public N1qlCouchbaseRepository(CouchbaseEntityInformation<T, String> metadata, CouchbaseOperations couchbaseOperations) {
        super(metadata, couchbaseOperations);
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        WherePath selectFrom = N1qlUtils.createSelectFromForEntity(this.getCouchbaseOperations().getCouchbaseBucket().name());
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(null, this.getCouchbaseOperations().getConverter(), this.getEntityInformation());
        com.couchbase.client.java.query.dsl.Sort[] orderings = N1qlUtils.createSort(sort, this.getCouchbaseOperations().getConverter());
        LimitPath st = selectFrom.where(whereCriteria).orderBy(orderings);
        ScanConsistency consistency = this.getCouchbaseOperations().getDefaultConsistency().n1qlConsistency();
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)st, (N1qlParams)N1qlParams.build().consistency(consistency));
        return this.getCouchbaseOperations().findByN1QL((N1qlQuery)query, this.getEntityInformation().getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        GroupByPath groupBy;
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        ScanConsistency consistency = this.getCouchbaseOperations().getDefaultConsistency().n1qlConsistency();
        Statement countStatement = N1qlUtils.createCountQueryForEntity(this.getCouchbaseOperations().getCouchbaseBucket().name(), this.getCouchbaseOperations().getConverter(), this.getEntityInformation());
        SimpleN1qlQuery countQuery = N1qlQuery.simple((Statement)countStatement, (N1qlParams)N1qlParams.build().consistency(consistency));
        List<CountFragment> countResult = this.getCouchbaseOperations().findByN1QLProjection((N1qlQuery)countQuery, CountFragment.class);
        long totalCount = countResult == null || countResult.isEmpty() ? 0L : countResult.get((int)0).count;
        WherePath selectFrom = N1qlUtils.createSelectFromForEntity(this.getCouchbaseOperations().getCouchbaseBucket().name());
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(null, this.getCouchbaseOperations().getConverter(), this.getEntityInformation());
        GroupByPath limitPath = groupBy = selectFrom.where(whereCriteria);
        if (pageable.getSort() != null) {
            com.couchbase.client.java.query.dsl.Sort[] orderings = N1qlUtils.createSort(pageable.getSort(), this.getCouchbaseOperations().getConverter());
            limitPath = groupBy.orderBy(orderings);
        }
        Statement pageStatement = limitPath.limit(pageable.getPageSize()).offset(pageable.getOffset());
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)pageStatement, (N1qlParams)N1qlParams.build().consistency(consistency));
        List pageContent = this.getCouchbaseOperations().findByN1QL((N1qlQuery)query, this.getEntityInformation().getJavaType());
        return new PageImpl(pageContent, pageable, totalCount);
    }
}

