/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.couchbase.core.convert.DateConverters;
import org.springframework.util.ClassUtils;

public final class CouchbaseJsr310Converters {
    private static final boolean JAVA_8_IS_PRESENT = ClassUtils.isPresent((String)"java.time.LocalDateTime", (ClassLoader)CouchbaseJsr310Converters.class.getClassLoader());

    private CouchbaseJsr310Converters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JAVA_8_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(NumberToLocalDateTimeConverter.INSTANCE);
        converters.add(LocalDateTimeToLongConverter.INSTANCE);
        converters.add(NumberToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToLongConverter.INSTANCE);
        converters.add(NumberToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToLongConverter.INSTANCE);
        converters.add(NumberToInstantConverter.INSTANCE);
        converters.add(InstantToLongConverter.INSTANCE);
        converters.add(ZoneIdToStringConverter.INSTANCE);
        converters.add(StringToZoneIdConverter.INSTANCE);
        converters.add(DurationToStringConverter.INSTANCE);
        converters.add(StringToDurationConverter.INSTANCE);
        converters.add(PeriodToStringConverter.INSTANCE);
        converters.add(StringToPeriodConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum StringToPeriodConverter implements Converter<String, Period>
    {
        INSTANCE;


        public Period convert(String s) {
            return Period.parse(s);
        }
    }

    @WritingConverter
    public static enum PeriodToStringConverter implements Converter<Period, String>
    {
        INSTANCE;


        public String convert(Period period) {
            return period.toString();
        }
    }

    @ReadingConverter
    public static enum StringToDurationConverter implements Converter<String, Duration>
    {
        INSTANCE;


        public Duration convert(String s) {
            return Duration.parse(s);
        }
    }

    @WritingConverter
    public static enum DurationToStringConverter implements Converter<Duration, String>
    {
        INSTANCE;


        public String convert(Duration duration) {
            return duration.toString();
        }
    }

    @ReadingConverter
    public static enum StringToZoneIdConverter implements Converter<String, ZoneId>
    {
        INSTANCE;


        public ZoneId convert(String source) {
            return ZoneId.of(source);
        }
    }

    @WritingConverter
    public static enum ZoneIdToStringConverter implements Converter<ZoneId, String>
    {
        INSTANCE;


        public String convert(ZoneId source) {
            return source.toString();
        }
    }

    @WritingConverter
    public static enum InstantToLongConverter implements Converter<Instant, Long>
    {
        INSTANCE;


        public Long convert(Instant source) {
            return source == null ? null : DateConverters.DateToLongConverter.INSTANCE.convert(Date.from(source.atZone(ZoneId.systemDefault()).toInstant()));
        }
    }

    @ReadingConverter
    public static enum NumberToInstantConverter implements Converter<Number, Instant>
    {
        INSTANCE;


        public Instant convert(Number source) {
            return source == null ? null : DateConverters.SerializedObjectToDateConverter.INSTANCE.convert(source).toInstant();
        }
    }

    @WritingConverter
    public static enum LocalTimeToLongConverter implements Converter<LocalTime, Long>
    {
        INSTANCE;


        public Long convert(LocalTime source) {
            return source == null ? null : DateConverters.DateToLongConverter.INSTANCE.convert(Date.from(source.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant()));
        }
    }

    @ReadingConverter
    public static enum NumberToLocalTimeConverter implements Converter<Number, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Number source) {
            return source == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(DateConverters.SerializedObjectToDateConverter.INSTANCE.convert(source).getTime()), ZoneId.systemDefault()).toLocalTime();
        }
    }

    @WritingConverter
    public static enum LocalDateToLongConverter implements Converter<LocalDate, Long>
    {
        INSTANCE;


        public Long convert(LocalDate source) {
            return source == null ? null : DateConverters.DateToLongConverter.INSTANCE.convert(Date.from(source.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
    }

    @ReadingConverter
    public static enum NumberToLocalDateConverter implements Converter<Number, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Number source) {
            return source == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(DateConverters.SerializedObjectToDateConverter.INSTANCE.convert(source).getTime()), ZoneId.systemDefault()).toLocalDate();
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToLongConverter implements Converter<LocalDateTime, Long>
    {
        INSTANCE;


        public Long convert(LocalDateTime source) {
            return source == null ? null : DateConverters.DateToLongConverter.INSTANCE.convert(Date.from(source.atZone(ZoneId.systemDefault()).toInstant()));
        }
    }

    @ReadingConverter
    public static enum NumberToLocalDateTimeConverter implements Converter<Number, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Number source) {
            return source == null ? null : LocalDateTime.ofInstant(DateConverters.SerializedObjectToDateConverter.INSTANCE.convert(source).toInstant(), ZoneId.systemDefault());
        }
    }
}

