/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.couchbase.config.AbstractCouchbaseDataConfiguration;
import org.springframework.data.couchbase.config.CouchbaseConfigurer;
import org.springframework.data.couchbase.config.CouchbaseEnvironmentNoShutdownProxy;

@Configuration
public abstract class AbstractCouchbaseConfiguration
extends AbstractCouchbaseDataConfiguration
implements CouchbaseConfigurer {
    protected abstract List<String> getBootstrapHosts();

    protected abstract String getBucketName();

    protected abstract String getBucketPassword();

    protected boolean isEnvironmentManagedBySpring() {
        return true;
    }

    protected CouchbaseEnvironment getEnvironment() {
        return DefaultCouchbaseEnvironment.create();
    }

    @Override
    protected CouchbaseConfigurer couchbaseConfigurer() {
        return this;
    }

    @Override
    @Bean(destroyMethod="shutdown", name={"couchbaseEnv"})
    public CouchbaseEnvironment couchbaseEnvironment() {
        CouchbaseEnvironment env = this.getEnvironment();
        if (this.isEnvironmentManagedBySpring()) {
            return env;
        }
        return new CouchbaseEnvironmentNoShutdownProxy(env);
    }

    @Override
    @Bean(destroyMethod="disconnect", name={"couchbaseCluster"})
    public Cluster couchbaseCluster() throws Exception {
        return CouchbaseCluster.create((CouchbaseEnvironment)this.couchbaseEnvironment(), this.getBootstrapHosts());
    }

    @Override
    @Bean(name={"couchbaseClusterInfo"})
    public ClusterInfo couchbaseClusterInfo() throws Exception {
        return this.couchbaseCluster().clusterManager(this.getBucketName(), this.getBucketPassword()).info();
    }

    @Override
    @Bean(destroyMethod="close", name={"couchbaseBucket"})
    public Bucket couchbaseClient() throws Exception {
        return this.couchbaseCluster().openBucket(this.getBucketName(), this.getBucketPassword());
    }
}

