/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.Delete;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class StringBasedN1qlQueryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringBasedN1qlQueryParser.class);
    public static final String SPEL_PREFIX = "n1ql";
    public static final String SPEL_SELECT_FROM_CLAUSE = "#n1ql.selectEntity";
    public static final String SPEL_BUCKET = "#n1ql.bucket";
    public static final String SPEL_ENTITY = "#n1ql.fields";
    public static final String SPEL_FILTER = "#n1ql.filter";
    public static final String SPEL_DELETE = "#n1ql.delete";
    public static final String SPEL_RETURNING = "#n1ql.returning";
    public static final Pattern NAMED_PLACEHOLDER_PATTERN = Pattern.compile("\\W(\\$\\p{Alpha}\\p{Alnum}*)\\b");
    public static final Pattern POSITIONAL_PLACEHOLDER_PATTERN = Pattern.compile("\\W(\\$\\p{Digit}+)\\b");
    public static final Pattern QUOTE_DETECTION_PATTERN = Pattern.compile("[\"'](?:[^\"'\\\\]*(?:\\\\.)?)*[\"']");
    private final String statement;
    private final QueryMethod queryMethod;
    private final PlaceholderType placeHolderType;
    private final N1qlSpelValues statementContext;
    private final N1qlSpelValues countContext;

    public StringBasedN1qlQueryParser(String statement, QueryMethod queryMethod, String bucketName, String typeField, Class<?> typeValue) {
        this.statement = statement;
        this.queryMethod = queryMethod;
        this.placeHolderType = this.checkPlaceholders(statement);
        this.statementContext = StringBasedN1qlQueryParser.createN1qlSpelValues(bucketName, typeField, typeValue, false);
        this.countContext = StringBasedN1qlQueryParser.createN1qlSpelValues(bucketName, typeField, typeValue, true);
    }

    public static N1qlSpelValues createN1qlSpelValues(String bucketName, String typeField, Class<?> typeValue, boolean isCount) {
        String b = "`" + bucketName + "`";
        String entity = "META(" + b + ").id AS " + "_ID" + ", META(" + b + ").cas AS " + "_CAS";
        String count = "COUNT(*) AS count";
        String selectEntity = isCount ? "SELECT " + count + " FROM " + b : "SELECT " + entity + ", " + b + ".* FROM " + b;
        String typeSelection = "`" + typeField + "` = \"" + typeValue.getName() + "\"";
        String delete = Delete.deleteFrom((com.couchbase.client.java.query.dsl.Expression)com.couchbase.client.java.query.dsl.Expression.i((String[])new String[]{bucketName})).toString();
        String returning = " returning " + N1qlUtils.createReturningExpressionForDelete(bucketName).toString();
        return new N1qlSpelValues(selectEntity, entity, b, typeSelection, delete, returning);
    }

    public String doParse(SpelExpressionParser parser, EvaluationContext evaluationContext, boolean isCountQuery) {
        Expression parsedExpression = parser.parseExpression(this.getStatement(), (ParserContext)new TemplateParserContext());
        if (isCountQuery) {
            evaluationContext.setVariable(SPEL_PREFIX, (Object)this.getCountContext());
        } else {
            evaluationContext.setVariable(SPEL_PREFIX, (Object)this.getStatementContext());
        }
        return (String)parsedExpression.getValue(evaluationContext, String.class);
    }

    private PlaceholderType checkPlaceholders(String statement) {
        String placeholder;
        Matcher quoteMatcher = QUOTE_DETECTION_PATTERN.matcher(statement);
        Matcher positionMatcher = POSITIONAL_PLACEHOLDER_PATTERN.matcher(statement);
        Matcher namedMatcher = NAMED_PLACEHOLDER_PATTERN.matcher(statement);
        ArrayList<int[]> quotes = new ArrayList<int[]>();
        while (quoteMatcher.find()) {
            quotes.add(new int[]{quoteMatcher.start(), quoteMatcher.end()});
        }
        int posCount = 0;
        int namedCount = 0;
        while (positionMatcher.find()) {
            placeholder = positionMatcher.group(1);
            if (!this.checkNotQuoted(placeholder, positionMatcher.start(), positionMatcher.end(), quotes)) continue;
            LOGGER.trace("{}: Found positional placeholder {}", (Object)this.queryMethod.getName(), (Object)placeholder);
            ++posCount;
        }
        while (namedMatcher.find()) {
            placeholder = namedMatcher.group(1);
            if (!this.checkNotQuoted(placeholder, namedMatcher.start(), namedMatcher.end(), quotes)) continue;
            LOGGER.trace("{}: Found named placeholder {}", (Object)this.queryMethod.getName(), (Object)placeholder);
            ++namedCount;
        }
        if (posCount > 0 && namedCount > 0) {
            throw new IllegalArgumentException("Using both named (" + namedCount + ") and positional (" + posCount + ") placeholders is not supported, please choose one over the other in " + this.queryMethod.getName());
        }
        if (posCount > 0) {
            return PlaceholderType.POSITIONAL;
        }
        if (namedCount > 0) {
            return PlaceholderType.NAMED;
        }
        return PlaceholderType.NONE;
    }

    private boolean checkNotQuoted(String item, int start, int end, List<int[]> quotes) {
        for (int[] quote : quotes) {
            if (quote[0] > start || quote[1] < end) continue;
            LOGGER.trace("{}: potential placeholder {} is inside quotes, ignored", (Object)this.queryMethod.getName(), (Object)item);
            return false;
        }
        return true;
    }

    private JsonValue getPositionalPlaceholderValues(ParameterAccessor accessor) {
        JsonArray posValues = JsonArray.create();
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            posValues.add(accessor.getBindableValue(parameter.getIndex()));
        }
        return posValues;
    }

    private JsonObject getNamedPlaceholderValues(ParameterAccessor accessor) {
        JsonObject namedValues = JsonObject.create();
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            String placeholder = parameter.getPlaceholder();
            Object value = accessor.getBindableValue(parameter.getIndex());
            if (placeholder != null && placeholder.charAt(0) == ':') {
                placeholder = placeholder.replaceFirst(":", "");
                namedValues.put(placeholder, value);
                continue;
            }
            parameter.getName().ifPresent(name -> namedValues.put(name, value));
        }
        return namedValues;
    }

    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        switch (this.placeHolderType) {
            case NAMED: {
                return this.getNamedPlaceholderValues(accessor);
            }
            case POSITIONAL: {
                return this.getPositionalPlaceholderValues(accessor);
            }
        }
        return JsonArray.empty();
    }

    protected boolean useGeneratedCountQuery() {
        return this.statement.contains(SPEL_SELECT_FROM_CLAUSE);
    }

    public N1qlSpelValues getCountContext() {
        return this.countContext;
    }

    public N1qlSpelValues getStatementContext() {
        return this.statementContext;
    }

    public String getStatement() {
        return this.statement;
    }

    public static final class N1qlSpelValues {
        public final String selectEntity;
        public final String fields;
        public final String bucket;
        public final String filter;
        public final String delete;
        public final String returning;

        public N1qlSpelValues(String selectClause, String entityFields, String bucket, String filter, String delete, String returning) {
            this.selectEntity = selectClause;
            this.fields = entityFields;
            this.bucket = bucket;
            this.filter = filter;
            this.delete = delete;
            this.returning = returning;
        }
    }

    private static enum PlaceholderType {
        NAMED,
        POSITIONAL,
        NONE;

    }
}

