/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.AggregateFunctions;
import com.couchbase.client.java.query.dsl.functions.MetaFunctions;
import com.couchbase.client.java.query.dsl.functions.StringFunctions;
import com.couchbase.client.java.query.dsl.functions.TypeFunctions;
import com.couchbase.client.java.query.dsl.path.FromPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ReturnedType;

public class N1qlUtils {
    public static final Converter<? super CouchbasePersistentProperty, String> FIELD_NAME_ESCAPED = new Converter<CouchbasePersistentProperty, String>(){

        public String convert(CouchbasePersistentProperty source) {
            return "`" + source.getFieldName() + "`";
        }
    };

    public static Expression escapedBucket(String bucketName) {
        return Expression.i((String[])new String[]{bucketName});
    }

    public static FromPath createSelectClauseForEntity(String bucketName, ReturnedType returnedType, CouchbaseConverter converter) {
        Expression bucket = N1qlUtils.escapedBucket(bucketName);
        Expression metaId = Expression.path((Object[])new Object[]{MetaFunctions.meta((Expression)bucket), "id"}).as("_ID");
        Expression metaCas = Expression.path((Object[])new Object[]{MetaFunctions.meta((Expression)bucket), "cas"}).as("_CAS");
        ArrayList<Expression> expList = new ArrayList<Expression>();
        expList.add(metaId);
        expList.add(metaCas);
        if (returnedType != null && returnedType.needsCustomConstruction()) {
            List properties = returnedType.getInputProperties();
            CouchbasePersistentEntity entity = (CouchbasePersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(returnedType.getDomainType());
            for (String property : properties) {
                expList.add(Expression.path((Object[])new Object[]{bucket, Expression.i((String[])new String[]{((CouchbasePersistentProperty)entity.getRequiredPersistentProperty(property)).getFieldName()})}));
            }
        } else {
            expList.add(Expression.path((Object[])new Object[]{bucket, "*"}));
        }
        Expression[] propertiesExp = new Expression[expList.size()];
        propertiesExp = expList.toArray(propertiesExp);
        return Select.select((Expression[])propertiesExp);
    }

    public static Expression createReturningExpressionForDelete(String bucketName) {
        Expression fullEntity = Expression.path((Object[])new Object[]{Expression.i((String[])new String[]{bucketName}), "*"});
        Expression metaId = Expression.path((Object[])new Object[]{MetaFunctions.meta((Expression)Expression.i((String[])new String[]{bucketName})), "id"}).as("_ID");
        Expression metaCas = Expression.path((Object[])new Object[]{MetaFunctions.meta((Expression)Expression.i((String[])new String[]{bucketName})), "cas"}).as("_CAS");
        ArrayList<Expression> expList = new ArrayList<Expression>();
        expList.add(fullEntity);
        expList.add(metaId);
        expList.add(metaCas);
        StringBuilder sb = new StringBuilder();
        for (Expression exp : expList) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(exp.toString());
        }
        return Expression.x((String)sb.toString());
    }

    public static FromPath createSelectClauseForEntity(String bucketName) {
        return N1qlUtils.createSelectClauseForEntity(bucketName, null, null);
    }

    public static WherePath createSelectFromForEntity(String bucketName) {
        return N1qlUtils.createSelectClauseForEntity(bucketName).from(N1qlUtils.escapedBucket(bucketName));
    }

    public static Expression createWhereFilterForEntity(Expression baseWhereCriteria, CouchbaseConverter converter, EntityMetadata<?> entityInformation) {
        String typeKey = converter.getTypeKey();
        String typeValue = entityInformation.getJavaType().getName();
        Expression typeSelector = Expression.i((String[])new String[]{typeKey}).eq(Expression.s((String[])new String[]{typeValue}));
        baseWhereCriteria = baseWhereCriteria == null ? typeSelector : Expression.x((String)("(" + baseWhereCriteria.toString() + ")")).and(typeSelector);
        return baseWhereCriteria;
    }

    public static PersistentPropertyPath<CouchbasePersistentProperty> getPathWithAlternativeFieldNames(CouchbaseConverter converter, PropertyPath property) {
        PersistentPropertyPath path = converter.getMappingContext().getPersistentPropertyPath(property);
        return path;
    }

    public static String getDottedPathWithAlternativeFieldNames(PersistentPropertyPath<CouchbasePersistentProperty> path) {
        return path.toDotPath(FIELD_NAME_ESCAPED);
    }

    public static com.couchbase.client.java.query.dsl.Sort[] createSort(Sort sort, CouchbaseConverter converter) {
        ArrayList<com.couchbase.client.java.query.dsl.Sort> cbSortList = new ArrayList<com.couchbase.client.java.query.dsl.Sort>();
        for (Sort.Order order : sort) {
            String orderProperty = order.getProperty();
            String[] orderPropertyParts = orderProperty.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (String part : orderPropertyParts) {
                if (sb.length() != 0) {
                    sb.append(".");
                }
                sb.append(Expression.i((String[])new String[]{part}).toString());
            }
            Expression orderFieldName = Expression.x((String)sb.toString());
            if (order.isIgnoreCase()) {
                orderFieldName = StringFunctions.lower((Expression)TypeFunctions.toString((Expression)orderFieldName));
            }
            if (order.isAscending()) {
                cbSortList.add(com.couchbase.client.java.query.dsl.Sort.asc((Expression)orderFieldName));
                continue;
            }
            cbSortList.add(com.couchbase.client.java.query.dsl.Sort.desc((Expression)orderFieldName));
        }
        return cbSortList.toArray(new com.couchbase.client.java.query.dsl.Sort[cbSortList.size()]);
    }

    public static <T> Statement createCountQueryForEntity(String bucketName, CouchbaseConverter converter, CouchbaseEntityInformation<T, String> entityInformation) {
        return Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*").as("count")}).from(N1qlUtils.escapedBucket(bucketName)).where(N1qlUtils.createWhereFilterForEntity(null, converter, entityInformation));
    }

    public static N1qlQuery buildQuery(Statement statement, JsonValue queryPlaceholderValues, ScanConsistency scanConsistency) {
        N1qlParams n1qlParams = N1qlParams.build().consistency(scanConsistency);
        Object query = queryPlaceholderValues instanceof JsonObject && !((JsonObject)queryPlaceholderValues).isEmpty() ? N1qlQuery.parameterized((Statement)statement, (JsonObject)((JsonObject)queryPlaceholderValues), (N1qlParams)n1qlParams) : (queryPlaceholderValues instanceof JsonArray && !((JsonArray)queryPlaceholderValues).isEmpty() ? N1qlQuery.parameterized((Statement)statement, (JsonArray)((JsonArray)queryPlaceholderValues), (N1qlParams)n1qlParams) : N1qlQuery.simple((Statement)statement, (N1qlParams)n1qlParams));
        return query;
    }
}

