/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.RawJsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.util.features.CouchbaseFeature;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.SpatialViewResult;
import com.couchbase.client.java.view.SpatialViewRow;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.BucketCallback;
import org.springframework.data.couchbase.core.CouchbaseDataIntegrityViolationException;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.core.OperationInterruptedException;
import org.springframework.data.couchbase.core.UnsupportedCouchbaseFeatureException;
import org.springframework.data.couchbase.core.WriteResultChecking;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.CouchbaseStorable;
import org.springframework.data.couchbase.core.mapping.KeySettings;
import org.springframework.data.couchbase.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.couchbase.core.query.Consistency;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import rx.Observable;
import rx.functions.Func1;

public class CouchbaseTemplate
implements CouchbaseOperations,
ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseTemplate.class);
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private static final Collection<String> ITERABLE_CLASSES;
    private final Bucket client;
    private final CouchbaseConverter converter;
    private final TranslationService translationService;
    private final ClusterInfo clusterInfo;
    private KeySettings keySettings;
    private ApplicationEventPublisher eventPublisher;
    private WriteResultChecking writeResultChecking = DEFAULT_WRITE_RESULT_CHECKING;
    private PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();
    protected final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private Consistency configuredConsistency = Consistency.DEFAULT_CONSISTENCY;

    public CouchbaseTemplate(ClusterInfo clusterInfo, Bucket client) {
        this(clusterInfo, client, null, null);
    }

    public CouchbaseTemplate(ClusterInfo clusterInfo, Bucket client, TranslationService translationService) {
        this(clusterInfo, client, null, translationService);
    }

    public CouchbaseTemplate(ClusterInfo clusterInfo, Bucket client, CouchbaseConverter converter, TranslationService translationService) {
        this.clusterInfo = clusterInfo;
        this.client = client;
        this.converter = converter == null ? this.getDefaultConverter() : converter;
        this.translationService = translationService == null ? this.getDefaultTranslationService() : translationService;
        this.mappingContext = this.converter.getMappingContext();
    }

    private TranslationService getDefaultTranslationService() {
        JacksonTranslationService t = new JacksonTranslationService();
        t.afterPropertiesSet();
        return t;
    }

    private CouchbaseConverter getDefaultConverter() {
        MappingCouchbaseConverter c = new MappingCouchbaseConverter((MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty>)new CouchbaseMappingContext());
        c.afterPropertiesSet();
        return c;
    }

    private Document<String> encodeAndWrap(CouchbaseDocument source, Long version) {
        String encodedContent = this.translationService.encode(source);
        if (version == null) {
            return RawJsonDocument.create((String)source.getId(), (int)source.getExpiration(), (String)encodedContent);
        }
        return RawJsonDocument.create((String)source.getId(), (int)source.getExpiration(), (String)encodedContent, (long)version);
    }

    private CouchbaseStorable decodeAndUnwrap(Document<String> source, CouchbaseStorable target) {
        return this.translationService.decode((String)source.content(), target);
    }

    protected static void ensureNotIterable(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    private void handleWriteResultError(String message, Exception cause) {
        if (this.writeResultChecking == WriteResultChecking.NONE) {
            return;
        }
        if (this.writeResultChecking == WriteResultChecking.EXCEPTION) {
            throw new CouchbaseDataIntegrityViolationException(message, cause);
        }
        LOGGER.error(message, (Throwable)cause);
    }

    public void setWriteResultChecking(WriteResultChecking writeResultChecking) {
        this.writeResultChecking = writeResultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : writeResultChecking;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected <T> void maybeEmitEvent(CouchbaseMappingEvent<T> event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    @Override
    public void save(Object objectToSave) {
        this.save(objectToSave, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void save(Object objectToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        this.doPersist(objectToSave, persistTo, replicateTo, PersistType.SAVE);
    }

    @Override
    public void save(Collection<?> batchToSave) {
        this.save(batchToSave, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void save(Collection<?> batchToSave, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object o : batchToSave) {
            this.doPersist(o, persistTo, replicateTo, PersistType.SAVE);
        }
    }

    @Override
    public void insert(Object objectToInsert) {
        this.insert(objectToInsert, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void insert(Object objectToInsert, PersistTo persistTo, ReplicateTo replicateTo) {
        this.doPersist(objectToInsert, persistTo, replicateTo, PersistType.INSERT);
    }

    @Override
    public void insert(Collection<?> batchToInsert) {
        this.insert(batchToInsert, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void insert(Collection<?> batchToInsert, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object o : batchToInsert) {
            this.doPersist(o, persistTo, replicateTo, PersistType.INSERT);
        }
    }

    @Override
    public void update(Object objectToUpdate) {
        this.update(objectToUpdate, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void update(Object objectToUpdate, PersistTo persistTo, ReplicateTo replicateTo) {
        this.doPersist(objectToUpdate, persistTo, replicateTo, PersistType.UPDATE);
    }

    @Override
    public void update(Collection<?> batchToUpdate) {
        this.update(batchToUpdate, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void update(Collection<?> batchToUpdate, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object o : batchToUpdate) {
            this.doPersist(o, persistTo, replicateTo, PersistType.UPDATE);
        }
    }

    @Override
    public <T> T findById(final String id, Class<T> entityClass) {
        final CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        RawJsonDocument result = this.execute(new BucketCallback<RawJsonDocument>(){

            @Override
            public RawJsonDocument doInBucket() {
                if (entity.isTouchOnRead()) {
                    return (RawJsonDocument)CouchbaseTemplate.this.client.getAndTouch(id, entity.getExpiry(), RawJsonDocument.class);
                }
                return (RawJsonDocument)CouchbaseTemplate.this.client.get(id, RawJsonDocument.class);
            }
        });
        return this.mapToEntity(id, (Document<String>)result, entityClass);
    }

    @Override
    public <T> List<T> findByView(ViewQuery query, final Class<T> entityClass) {
        if (!query.isIncludeDocs() || !query.includeDocsTarget().equals(RawJsonDocument.class)) {
            if (query.isOrderRetained()) {
                query.includeDocsOrdered(RawJsonDocument.class);
            } else {
                query.includeDocs(RawJsonDocument.class);
            }
        }
        query.reduce(false);
        return (List)this.executeAsync(this.client.async().query(query)).flatMap((Func1)new Func1<AsyncViewResult, Observable<AsyncViewRow>>(){

            public Observable<AsyncViewRow> call(AsyncViewResult asyncViewResult) {
                return asyncViewResult.error().flatMap((Func1)new Func1<JsonObject, Observable<AsyncViewRow>>(){

                    public Observable<AsyncViewRow> call(JsonObject error) {
                        return Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute view query due to the following view error: " + error.toString())));
                    }
                }).switchIfEmpty(asyncViewResult.rows());
            }
        }).flatMap(new Func1<AsyncViewRow, Observable<T>>(){

            public Observable<T> call(AsyncViewRow row) {
                final String id = row.id();
                return row.document(RawJsonDocument.class).map(new Func1<RawJsonDocument, T>(){

                    public T call(RawJsonDocument rawJsonDocument) {
                        Object entity = CouchbaseTemplate.this.mapToEntity(id, (Document<String>)((Document)rawJsonDocument), entityClass);
                        return entity;
                    }
                });
            }
        }).filter(new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return t != null;
            }
        }).onErrorResumeNext(new Func1<Throwable, Observable<T>>(){

            public Observable<T> call(Throwable throwable) {
                if (throwable instanceof TranscodingException) {
                    return Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute view query", throwable)));
                }
                return Observable.error((Throwable)throwable);
            }
        }).toList().toBlocking().single();
    }

    @Override
    public ViewResult queryView(final ViewQuery query) {
        return this.execute(new BucketCallback<ViewResult>(){

            @Override
            public ViewResult doInBucket() {
                return CouchbaseTemplate.this.client.query(query);
            }
        });
    }

    @Override
    public <T> List<T> findBySpatialView(SpatialViewQuery query, Class<T> entityClass) {
        query.includeDocs(false);
        try {
            SpatialViewResult response = this.querySpatialView(query);
            if (response.error() != null) {
                throw new CouchbaseQueryExecutionException("Unable to execute spatial view query due to the following view error: " + response.error().toString());
            }
            List allRows = response.allRows();
            ArrayList<T> result = new ArrayList<T>(allRows.size());
            for (SpatialViewRow row : allRows) {
                T entity = this.mapToEntity(row.id(), (Document<String>)row.document(RawJsonDocument.class), entityClass);
                if (entity == null) continue;
                result.add(entity);
            }
            return result;
        }
        catch (TranscodingException e) {
            throw new CouchbaseQueryExecutionException("Unable to execute view query", e);
        }
    }

    @Override
    public SpatialViewResult querySpatialView(final SpatialViewQuery query) {
        return this.execute(new BucketCallback<SpatialViewResult>(){

            @Override
            public SpatialViewResult doInBucket() throws TimeoutException, ExecutionException, InterruptedException {
                return CouchbaseTemplate.this.client.query(query);
            }
        });
    }

    @Override
    public <T> List<T> findByN1QL(N1qlQuery n1ql, Class<T> entityClass) {
        this.checkN1ql();
        try {
            N1qlQueryResult queryResult = this.queryN1QL(n1ql);
            if (queryResult.finalSuccess()) {
                List allRows = queryResult.allRows();
                ArrayList<T> result = new ArrayList<T>(allRows.size());
                for (N1qlQueryRow row : allRows) {
                    JsonObject json = row.value();
                    String id = json.getString("_ID");
                    Long cas = json.getLong("_CAS");
                    if (id == null || cas == null) {
                        throw new CouchbaseQueryExecutionException("Unable to retrieve enough metadata for N1QL to entity mapping, have you selected _ID and _CAS?");
                    }
                    json = json.removeKey("_ID").removeKey("_CAS");
                    RawJsonDocument entityDoc = RawJsonDocument.create((String)id, (String)json.toString(), (long)cas);
                    T decoded = this.mapToEntity(id, (Document<String>)entityDoc, entityClass);
                    result.add(decoded);
                }
                return result;
            }
            StringBuilder message = new StringBuilder("Unable to execute query due to the following n1ql errors: ");
            for (JsonObject error : queryResult.errors()) {
                message.append('\n').append(error);
            }
            throw new CouchbaseQueryExecutionException(message.toString());
        }
        catch (TranscodingException e) {
            throw new CouchbaseQueryExecutionException("Unable to execute query", e);
        }
    }

    @Override
    public <T> List<T> findByN1QLProjection(N1qlQuery n1ql, Class<T> entityClass) {
        this.checkN1ql();
        try {
            N1qlQueryResult queryResult = this.queryN1QL(n1ql);
            if (queryResult.finalSuccess()) {
                List allRows = queryResult.allRows();
                ArrayList<T> result = new ArrayList<T>(allRows.size());
                for (N1qlQueryRow row : allRows) {
                    JsonObject json = row.value();
                    T decoded = this.translationService.decodeFragment(json.toString(), entityClass);
                    result.add(decoded);
                }
                return result;
            }
            StringBuilder message = new StringBuilder("Unable to execute query due to the following n1ql errors: ");
            for (JsonObject error : queryResult.errors()) {
                message.append('\n').append(error);
            }
            throw new CouchbaseQueryExecutionException(message.toString());
        }
        catch (TranscodingException e) {
            throw new CouchbaseQueryExecutionException("Unable to execute query", e);
        }
    }

    @Override
    public N1qlQueryResult queryN1QL(final N1qlQuery query) {
        this.checkN1ql();
        return this.execute(new BucketCallback<N1qlQueryResult>(){

            @Override
            public N1qlQueryResult doInBucket() throws TimeoutException, ExecutionException, InterruptedException {
                return CouchbaseTemplate.this.client.query(query);
            }
        });
    }

    @Override
    public boolean exists(final String id) {
        return this.execute(new BucketCallback<Boolean>(){

            @Override
            public Boolean doInBucket() throws TimeoutException, ExecutionException, InterruptedException {
                return CouchbaseTemplate.this.client.exists(id);
            }
        });
    }

    @Override
    public void remove(Object objectToRemove) {
        this.remove(objectToRemove, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void remove(Object objectToRemove, PersistTo persistTo, ReplicateTo replicateTo) {
        this.doRemove(objectToRemove, persistTo, replicateTo);
    }

    @Override
    public void remove(Collection<?> batchToRemove) {
        this.remove(batchToRemove, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public void remove(Collection<?> batchToRemove, PersistTo persistTo, ReplicateTo replicateTo) {
        for (Object o : batchToRemove) {
            this.doRemove(o, persistTo, replicateTo);
        }
    }

    @Override
    public <T> T execute(BucketCallback<T> action) {
        try {
            return action.doInBucket();
        }
        catch (RuntimeException e) {
            throw this.exceptionTranslator.translateExceptionIfPossible(e);
        }
        catch (TimeoutException e) {
            throw new QueryTimeoutException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new OperationInterruptedException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new OperationInterruptedException(e.getMessage(), e);
        }
    }

    public <T> Observable<T> executeAsync(Observable<T> asyncAction) {
        return asyncAction.onErrorResumeNext(new Func1<Throwable, Observable<T>>(){

            public Observable<T> call(Throwable e) {
                if (e instanceof RuntimeException) {
                    return Observable.error((Throwable)CouchbaseTemplate.this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)e));
                }
                if (e instanceof TimeoutException) {
                    return Observable.error((Throwable)new QueryTimeoutException(e.getMessage(), e));
                }
                if (e instanceof InterruptedException) {
                    return Observable.error((Throwable)((Object)new OperationInterruptedException(e.getMessage(), e)));
                }
                if (e instanceof ExecutionException) {
                    return Observable.error((Throwable)((Object)new OperationInterruptedException(e.getMessage(), e)));
                }
                return Observable.error((Throwable)e);
            }
        });
    }

    private void doPersist(Object objectToPersist, final PersistTo persistTo, final ReplicateTo replicateTo, final PersistType persistType) {
        CouchbaseTemplate.ensureNotIterable(objectToPersist);
        final ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(objectToPersist);
        final CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(objectToPersist.getClass());
        final CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)persistentEntity.getVersionProperty();
        final Long version = versionProperty != null ? (Long)accessor.getProperty((PersistentProperty)versionProperty, Long.class) : null;
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(objectToPersist));
        final CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(objectToPersist, converted);
        this.maybeEmitEvent(new BeforeSaveEvent<Object>(objectToPersist, converted));
        this.execute(new BucketCallback<Boolean>(){

            @Override
            public Boolean doInBucket() throws InterruptedException, ExecutionException {
                String generatedId = CouchbaseTemplate.this.addCommonPrefixAndSuffix(converted.getId());
                converted.setId(generatedId);
                Document doc = CouchbaseTemplate.this.encodeAndWrap(converted, version);
                boolean versionPresent = versionProperty != null;
                boolean existingDocument = version != null && version > 0L;
                try {
                    Document storedDoc;
                    switch (persistType) {
                        case SAVE: {
                            if (!versionPresent) {
                                storedDoc = CouchbaseTemplate.this.client.upsert(doc, persistTo, replicateTo);
                                break;
                            }
                            if (existingDocument) {
                                storedDoc = CouchbaseTemplate.this.client.replace(doc, persistTo, replicateTo);
                                break;
                            }
                            storedDoc = CouchbaseTemplate.this.client.insert(doc, persistTo, replicateTo);
                            break;
                        }
                        case UPDATE: {
                            storedDoc = CouchbaseTemplate.this.client.replace(doc, persistTo, replicateTo);
                            break;
                        }
                        default: {
                            storedDoc = CouchbaseTemplate.this.client.insert(doc, persistTo, replicateTo);
                        }
                    }
                    CouchbasePersistentProperty idProperty = (CouchbasePersistentProperty)persistentEntity.getIdProperty();
                    Object entityId = accessor.getProperty((PersistentProperty)idProperty);
                    if (!generatedId.equals(entityId)) {
                        accessor.setProperty((PersistentProperty)idProperty, (Object)generatedId);
                    }
                    if (storedDoc != null && storedDoc.cas() != 0L) {
                        if (versionProperty != null) {
                            accessor.setProperty((PersistentProperty)versionProperty, (Object)storedDoc.cas());
                        }
                        return true;
                    }
                    return false;
                }
                catch (DocumentAlreadyExistsException e) {
                    throw new OptimisticLockingFailureException(persistType.getSpringDataOperationName() + " document with version value failed: " + version, (Throwable)e);
                }
                catch (CASMismatchException e) {
                    throw new OptimisticLockingFailureException(persistType.getSpringDataOperationName() + " document with version value failed: " + version, (Throwable)e);
                }
                catch (Exception e) {
                    CouchbaseTemplate.this.handleWriteResultError(persistType.getSpringDataOperationName() + " document failed: " + e.getMessage(), e);
                    return false;
                }
            }
        });
        this.maybeEmitEvent(new AfterSaveEvent<Object>(objectToPersist, converted));
    }

    private void doRemove(final Object objectToRemove, final PersistTo persistTo, final ReplicateTo replicateTo) {
        CouchbaseTemplate.ensureNotIterable(objectToRemove);
        this.maybeEmitEvent(new BeforeDeleteEvent<Object>(objectToRemove));
        if (objectToRemove instanceof String) {
            this.execute(new BucketCallback<Boolean>(){

                @Override
                public Boolean doInBucket() throws InterruptedException, ExecutionException {
                    try {
                        RawJsonDocument deletedDoc = (RawJsonDocument)CouchbaseTemplate.this.client.remove((String)objectToRemove, persistTo, replicateTo, RawJsonDocument.class);
                        return deletedDoc != null;
                    }
                    catch (Exception e) {
                        CouchbaseTemplate.this.handleWriteResultError("Delete document failed: " + e.getMessage(), e);
                        return false;
                    }
                }
            });
            this.maybeEmitEvent(new AfterDeleteEvent<Object>(objectToRemove));
            return;
        }
        final CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(objectToRemove, converted);
        this.execute(new BucketCallback<Boolean>(){

            @Override
            public Boolean doInBucket() {
                try {
                    RawJsonDocument deletedDoc = (RawJsonDocument)CouchbaseTemplate.this.client.remove(CouchbaseTemplate.this.addCommonPrefixAndSuffix(converted.getId()), persistTo, replicateTo, RawJsonDocument.class);
                    return deletedDoc != null;
                }
                catch (Exception e) {
                    CouchbaseTemplate.this.handleWriteResultError("Delete document failed: " + e.getMessage(), e);
                    return false;
                }
            }
        });
        this.maybeEmitEvent(new AfterDeleteEvent<Object>(objectToRemove));
    }

    private <T> T mapToEntity(String id, Document<String> data, Class<T> entityClass) {
        if (data == null) {
            return null;
        }
        CouchbaseDocument converted = new CouchbaseDocument(id);
        Object readEntity = this.converter.read(entityClass, (CouchbaseDocument)this.decodeAndUnwrap(data, converted));
        ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(readEntity);
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(readEntity.getClass());
        if (persistentEntity.getVersionProperty() != null) {
            accessor.setProperty(persistentEntity.getVersionProperty(), (Object)data.cas());
        }
        return (T)accessor.getBean();
    }

    private final <T> ConvertingPropertyAccessor<T> getPropertyAccessor(T source) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    private void checkN1ql() {
        if (!this.getCouchbaseClusterInfo().checkAvailable(CouchbaseFeature.N1QL)) {
            throw new UnsupportedCouchbaseFeatureException("Detected usage of N1QL in template, which is unsupported on this cluster", CouchbaseFeature.N1QL);
        }
    }

    @Override
    public Bucket getCouchbaseBucket() {
        return this.client;
    }

    @Override
    public ClusterInfo getCouchbaseClusterInfo() {
        return this.clusterInfo;
    }

    @Override
    public CouchbaseConverter getConverter() {
        return this.converter;
    }

    @Override
    public Consistency getDefaultConsistency() {
        return this.configuredConsistency;
    }

    public void setDefaultConsistency(Consistency consistency) {
        this.configuredConsistency = consistency;
    }

    @Override
    public void keySettings(KeySettings settings) {
        if (this.keySettings != null) {
            throw new UnsupportedOperationException("Key settings is already set, it is no longer mutable");
        }
        this.keySettings = settings;
    }

    @Override
    public KeySettings keySettings() {
        return this.keySettings;
    }

    @Override
    public String getGeneratedId(Object entity) {
        CouchbaseTemplate.ensureNotIterable(entity);
        CouchbaseDocument converted = new CouchbaseDocument();
        this.converter.write(entity, converted);
        return this.addCommonPrefixAndSuffix(converted.getId());
    }

    private String addCommonPrefixAndSuffix(String id) {
        String convertedKey = id;
        if (this.keySettings == null) {
            return id;
        }
        String prefix = this.keySettings.prefix();
        String delimiter = this.keySettings.delimiter();
        String suffix = this.keySettings.suffix();
        if (prefix != null && !prefix.equals("")) {
            convertedKey = prefix + delimiter + convertedKey;
        }
        if (suffix != null && !suffix.equals("")) {
            convertedKey = convertedKey + delimiter + suffix;
        }
        return convertedKey;
    }

    static {
        HashSet<String> iterableClasses = new HashSet<String>();
        iterableClasses.add(List.class.getName());
        iterableClasses.add(Collection.class.getName());
        iterableClasses.add(Iterator.class.getName());
        ITERABLE_CLASSES = Collections.unmodifiableCollection(iterableClasses);
    }

    private static enum PersistType {
        SAVE("Save", "Upsert"),
        INSERT("Insert", "Insert"),
        UPDATE("Update", "Replace");

        private final String sdkOperationName;
        private final String springDataOperationName;

        private PersistType(String sdkOperationName, String springDataOperationName) {
            this.sdkOperationName = sdkOperationName;
            this.springDataOperationName = springDataOperationName;
        }

        public String getSdkOperationName() {
            return this.sdkOperationName;
        }

        public String getSpringDataOperationName() {
            return this.springDataOperationName;
        }
    }
}

