/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByQueryOperationSupport
implements ReactiveFindByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveFindByQueryOperationSupport.class);

    public ReactiveFindByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByQueryOperation.ReactiveFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ReactiveFindByQuerySupport<T>(this.template, domainType, domainType, ALL_QUERY, null, null, null, null, null, this.template.support());
    }

    static class ReactiveFindByQuerySupport<T>
    implements ReactiveFindByQueryOperation.ReactiveFindByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;
        private final String collection;
        private String scope;
        private final String[] distinctFields;
        private final QueryOptions options;
        private final ReactiveTemplateSupport support;

        ReactiveFindByQuerySupport(ReactiveCouchbaseTemplate template, Class<?> domainType, Class<T> returnType, Query query, QueryScanConsistency scanConsistency, String scope, String collection, QueryOptions options, String[] distinctFields, ReactiveTemplateSupport support) {
            Assert.notNull(domainType, (String)"domainType must not be null!");
            Assert.notNull(returnType, (String)"returnType must not be null!");
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.distinctFields = distinctFields;
            this.support = support;
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithQuery<T> matching(Query query) {
            QueryScanConsistency scanCons = query.getScanConsistency() != null ? query.getScanConsistency() : this.scanConsistency;
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, query, scanCons, this.scope, this.collection, this.options, this.distinctFields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.TerminatingFindByQuery<T> withOptions(QueryOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, options, this.distinctFields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryInCollection<T> inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, scope, this.collection, this.options, this.distinctFields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithConsistency<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, collection, this.options, this.distinctFields, this.support);
        }

        @Override
        @Deprecated
        public ReactiveFindByQueryOperation.FindByQueryConsistentWith<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithConsistency<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.support);
        }

        @Override
        public <R> ReactiveFindByQueryOperation.FindByQueryWithConsistency<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"returnType must not be null!");
            return new ReactiveFindByQuerySupport<R>(this.template, this.domainType, returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, this.distinctFields, this.support);
        }

        @Override
        public ReactiveFindByQueryOperation.FindByQueryWithDistinct<T> distinct(String[] distinctFields) {
            Assert.notNull((Object)distinctFields, (String)"distinctFields must not be null!");
            return new ReactiveFindByQuerySupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, distinctFields, this.support);
        }

        @Override
        public Mono<T> one() {
            return this.all().singleOrEmpty();
        }

        @Override
        public Mono<T> first() {
            return this.all().next();
        }

        @Override
        public Flux<T> all() {
            return Flux.defer(() -> {
                PseudoArgs<QueryOptions> pArgs = new PseudoArgs<QueryOptions>(this.template, this.scope, this.collection, this.options);
                String statement = this.assembleEntityQuery(false, this.distinctFields, pArgs.getCollection());
                LOG.trace("statement: {} {}", (Object)"findByQuery", (Object)statement);
                Mono allResult = pArgs.getScope() == null ? this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.buildOptions(pArgs.getOptions())) : this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getScope().reactive().query(statement, this.buildOptions(pArgs.getOptions()));
                return allResult.onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).flatMap(row -> {
                    String id = "";
                    long cas = 0L;
                    if (this.distinctFields == null) {
                        if (row.getString("__id") == null) {
                            return Flux.error((Throwable)new CouchbaseException("query did not project __id. Either use #{#n1ql.selectEntity} or project __id and __cas : " + statement));
                        }
                        id = row.getString("__id");
                        if (row.getLong("__cas") == null) {
                            return Flux.error((Throwable)new CouchbaseException("query did not project __cas. Either use #{#n1ql.selectEntity} or project __id and __cas : " + statement));
                        }
                        cas = row.getLong("__cas");
                        row.removeKey("__id");
                        row.removeKey("__cas");
                    }
                    return this.support.decodeEntity(id, row.toString(), cas, this.returnType);
                });
            });
        }

        @Override
        public QueryOptions buildOptions(QueryOptions options) {
            QueryScanConsistency qsc = this.scanConsistency != null ? this.scanConsistency : this.template.getConsistency();
            QueryOptions opts = this.query.buildQueryOptions(options, qsc);
            return opts;
        }

        @Override
        public Mono<Long> count() {
            return Mono.defer(() -> {
                PseudoArgs<QueryOptions> pArgs = new PseudoArgs<QueryOptions>(this.template, this.scope, this.collection, this.options);
                String statement = this.assembleEntityQuery(true, this.distinctFields, pArgs.getCollection());
                LOG.trace("statement: {} {}", (Object)"findByQuery", (Object)statement);
                Mono countResult = this.collection == null ? this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.buildOptions(pArgs.getOptions())) : this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getScope().reactive().query(statement, this.buildOptions(pArgs.getOptions()));
                return countResult.onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> row.getLong((String)row.getNames().iterator().next())).next();
            });
        }

        @Override
        public Mono<Boolean> exists() {
            return this.count().map(count -> count > 0L);
        }

        private String assembleEntityQuery(boolean count, String[] distinctFields, String collection) {
            return this.query.toN1qlSelectString(this.template, collection, this.domainType, this.returnType, count, distinctFields);
        }
    }
}

