/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping.event;

import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAfterConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveAuditingEntityCallback
implements ReactiveBeforeConvertCallback<Object>,
ReactiveAfterConvertCallback<Object>,
Ordered {
    private final ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveAuditingEntityCallback.class);

    public ReactiveAuditingEntityCallback(ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"ReactiveIsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Publisher<Object> onBeforeConvert(Object entity, String collection) {
        LOG.debug("onBeforeConvert " + entity.toString());
        return ((ReactiveIsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }

    @Override
    public Publisher<Object> onAfterConvert(Object entity, CouchbaseDocument document, String collection) {
        LOG.debug("onAfterConvert " + document.toString());
        return Mono.just((Object)entity);
    }

    public int getOrder() {
        return 100;
    }
}

