/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveInsertByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveInsertByIdOperationSupport
implements ReactiveInsertByIdOperation {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveInsertByIdOperationSupport.class);
    private final ReactiveCouchbaseTemplate template;

    public ReactiveInsertByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveInsertByIdOperation.ReactiveInsertById<T> insertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveInsertByIdSupport<T>(this.template, domainType, null, null, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null, this.template.support());
    }

    static class ReactiveInsertByIdSupport<T>
    implements ReactiveInsertByIdOperation.ReactiveInsertById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final InsertOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveTemplateSupport support;

        ReactiveInsertByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, InsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.support = support;
        }

        @Override
        public Mono<T> one(T object) {
            PseudoArgs<InsertOptions> pArgs = new PseudoArgs<InsertOptions>(this.template, this.scope, this.collection, this.options != null ? this.options : InsertOptions.insertOptions());
            LOG.trace("statement: {} scope: {} collection: {} options: {}", new Object[]{"insertById", pArgs.getScope(), pArgs.getCollection(), pArgs.getOptions()});
            return Mono.just(object).flatMap(this.support::encodeEntity).flatMap(converted -> this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive().insert(converted.getId(), converted.export(), this.buildOptions((InsertOptions)pArgs.getOptions(), (CouchbaseDocument)converted)).flatMap(result -> this.support.applyUpdatedId(object, converted.getId()).flatMap(updatedObject -> this.support.applyUpdatedCas(updatedObject, (CouchbaseDocument)converted, result.cas())))).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        @Override
        public InsertOptions buildOptions(InsertOptions options, CouchbaseDocument doc) {
            InsertOptions insertOptions = options = options != null ? options : InsertOptions.insertOptions();
            if (this.persistTo != PersistTo.NONE || this.replicateTo != ReplicateTo.NONE) {
                options.durability(this.persistTo, this.replicateTo);
            } else if (this.durabilityLevel != DurabilityLevel.NONE) {
                options.durability(this.durabilityLevel);
            }
            if (this.expiry != null) {
                options.expiry(this.expiry);
            } else if (doc.getExpiration() != 0) {
                options.expiry(Duration.ofSeconds(doc.getExpiration()));
            }
            return options;
        }

        @Override
        public ReactiveInsertByIdOperation.TerminatingInsertById<T> withOptions(InsertOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdInCollection<T> inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithOptions<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdInCollection<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdInCollection<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveInsertByIdOperation.InsertByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveInsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry, this.support);
        }
    }
}

