/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRemoveByQueryOperationSupport
implements ReactiveRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveRemoveByQueryOperationSupport.class);

    public ReactiveRemoveByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ReactiveRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, null, null, null, null);
    }

    static class ReactiveRemoveByQuerySupport<T>
    implements ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;
        private final String scope;
        private final String collection;
        private final QueryOptions options;

        ReactiveRemoveByQuerySupport(ReactiveCouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency, String scope, String collection, QueryOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
        }

        @Override
        public Flux<RemoveResult> all() {
            return Flux.defer(() -> {
                PseudoArgs<QueryOptions> pArgs = new PseudoArgs<QueryOptions>(this.template, this.scope, this.collection, this.options);
                String statement = this.assembleDeleteQuery(pArgs.getCollection());
                LOG.trace("statement: {}", (Object)statement);
                Mono allResult = pArgs.getCollection() == null ? this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.buildQueryOptions(pArgs.getOptions())) : this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getScope().reactive().query(statement, this.buildQueryOptions(pArgs.getOptions()));
                return allResult.onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> new RemoveResult(row.getString("__id"), row.getLong("__cas"), Optional.empty()));
            });
        }

        private QueryOptions buildQueryOptions(QueryOptions options) {
            return this.query.buildQueryOptions(options, this.scanConsistency);
        }

        @Override
        public ReactiveRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryWithConsistency<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, this.scope, collection, this.options);
        }

        @Override
        @Deprecated
        public ReactiveRemoveByQueryOperation.RemoveByQueryInScope<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        private String assembleDeleteQuery(String collection) {
            return this.query.toN1qlRemoveString(this.template, collection, this.domainType);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryWithQuery<T> withOptions(QueryOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, this.scope, this.collection, options);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryInCollection<T> inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, scope, this.collection, this.options);
        }
    }
}

