/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.Dimensional;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.core.query.WithConsistency;
import org.springframework.data.couchbase.repository.Meta;
import org.springframework.data.couchbase.repository.Query;
import org.springframework.data.couchbase.repository.ScanConsistency;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CouchbaseQueryMethod
extends QueryMethod {
    private final Method method;

    public CouchbaseQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext) {
        super(method, metadata, factory);
        this.method = method;
    }

    public boolean hasViewAnnotation() {
        return this.getViewAnnotation() != null;
    }

    public boolean hasViewSpecification() {
        return this.hasDesignDoc() && this.hasViewName();
    }

    public boolean hasDesignDoc() {
        View annotation = this.getViewAnnotation();
        if (annotation == null) {
            return false;
        }
        return StringUtils.hasText((String)annotation.designDocument());
    }

    public boolean hasViewName() {
        View annotation = this.getViewAnnotation();
        if (annotation == null) {
            return false;
        }
        return StringUtils.hasText((String)annotation.viewName());
    }

    public View getViewAnnotation() {
        return this.method.getAnnotation(View.class);
    }

    public boolean hasDimensionalAnnotation() {
        return this.getDimensionalAnnotation() != null;
    }

    public Dimensional getDimensionalAnnotation() {
        return (Dimensional)AnnotationUtils.findAnnotation((Method)this.method, Dimensional.class);
    }

    public boolean hasN1qlAnnotation() {
        return this.getN1qlAnnotation() != null;
    }

    public Query getN1qlAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    public boolean hasInlineN1qlQuery() {
        return this.getInlineN1qlQuery() != null;
    }

    public boolean hasConsistencyAnnotation() {
        return this.getConsistencyAnnotation() != null;
    }

    public WithConsistency getConsistencyAnnotation() {
        return this.method.getAnnotation(WithConsistency.class);
    }

    public boolean hasScanConsistencyAnnotation() {
        return this.getScanConsistencyAnnotation() != null;
    }

    public ScanConsistency getScanConsistencyAnnotation() {
        return this.method.getAnnotation(ScanConsistency.class);
    }

    public boolean hasQueryMetaAttributes() {
        return this.getMetaAnnotation() != null;
    }

    private Meta getMetaAnnotation() {
        return this.method.getAnnotation(Meta.class);
    }

    @Nullable
    public org.springframework.data.couchbase.core.query.Meta getQueryMetaAttributes() {
        Meta meta = this.getMetaAnnotation();
        if (meta == null) {
            return new org.springframework.data.couchbase.core.query.Meta();
        }
        org.springframework.data.couchbase.core.query.Meta metaAttributes = new org.springframework.data.couchbase.core.query.Meta();
        return metaAttributes;
    }

    public String getInlineN1qlQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getN1qlAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    public boolean isDeleteQuery() {
        return this.getName().toLowerCase(Locale.ROOT).startsWith("delete");
    }

    public boolean isExistsQuery() {
        return this.getName().toLowerCase(Locale.ROOT).startsWith("exists");
    }

    public boolean isCountQuery() {
        return this.getName().toLowerCase(Locale.ROOT).startsWith("count");
    }

    public String toString() {
        return super.toString();
    }

    public boolean hasReactiveWrapperParameter() {
        for (Parameter p : this.getParameters()) {
            if (!ReactiveWrapperConverters.supports((Class)p.getType())) continue;
            return true;
        }
        return false;
    }
}

