/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.kv.ExistsOptions;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableExistsByIdOperation;
import org.springframework.data.couchbase.core.ReactiveExistsByIdOperationSupport;
import org.springframework.util.Assert;

public class ExecutableExistsByIdOperationSupport
implements ExecutableExistsByIdOperation {
    private final CouchbaseTemplate template;

    ExecutableExistsByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ExecutableExistsByIdOperation.ExecutableExistsById existsById() {
        return new ExecutableExistsByIdSupport(this.template, null, null, null);
    }

    static class ExecutableExistsByIdSupport
    implements ExecutableExistsByIdOperation.ExecutableExistsById {
        private final CouchbaseTemplate template;
        private final String scope;
        private final String collection;
        private final ExistsOptions options;
        private final ReactiveExistsByIdOperationSupport.ReactiveExistsByIdSupport reactiveSupport;

        ExecutableExistsByIdSupport(CouchbaseTemplate template, String scope, String collection, ExistsOptions options) {
            this.template = template;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.reactiveSupport = new ReactiveExistsByIdOperationSupport.ReactiveExistsByIdSupport(template.reactive(), scope, collection, options);
        }

        @Override
        public boolean one(String id) {
            return (Boolean)this.reactiveSupport.one(id).block();
        }

        @Override
        public Map<String, Boolean> all(Collection<String> ids) {
            return (Map)this.reactiveSupport.all(ids).block();
        }

        @Override
        public ExecutableExistsByIdOperation.ExistsByIdWithOptions inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableExistsByIdSupport(this.template, this.scope, collection, this.options);
        }

        @Override
        public ExecutableExistsByIdOperation.TerminatingExistsById withOptions(ExistsOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableExistsByIdSupport(this.template, this.scope, this.collection, options);
        }

        @Override
        public ExecutableExistsByIdOperation.ExistsByIdInCollection inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ExecutableExistsByIdSupport(this.template, scope, this.collection, this.options);
        }
    }
}

